/***************************************************************************
                          kbearinfoview.cpp  -  description
                             -------------------
    begin                : mn apr 15 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qwhatsthis.h>
/////////////////////////////////////////////////////
// KDE specific includes
#include <kdebug.h>
#include <klocale.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbearinfoview.h"
#include "kbearmdichildview.h"
#include "kbear.h"

//-----------------------------------------------
KBearInfoView::KBearInfoView( QWidget* parent, const char* n )
	:	KBearTabView(parent,n )
{
	QString name = i18n("Log Messages");
	QString toolTip = i18n("This window displays all commands sent to the remote servers "
								"as well as the received responds.");
	m_logView = new KBearLogView( this, name );
	m_logView->setCaption( name );
	QWhatsThis::add( m_logView, toolTip);
//	addTab( m_logView, name );
	connect( m_logView, SIGNAL( imShowing() ),
				this, SLOT( slotLogShowing() ) );
	connect( m_logView, SIGNAL( imHiding() ),
				this, SLOT( slotLogHiding() ) );

	name = i18n("Transfers");
	toolTip = i18n("This window displays all active or queued transfers.");
	m_transferView = new KBearTransferView( this, name );
	m_transferView->setCaption( name );
	QWhatsThis::add( m_transferView, toolTip);
//	addTab( m_transferView, name );
	connect( m_transferView, SIGNAL( imShowing() ),
				this, SLOT( slotTransferShowing() ) );
	connect( m_transferView, SIGNAL( imHiding() ),
				this, SLOT( slotTransferHiding() ) );
	connect( m_transferView, SIGNAL( start( Transfer* ) ), SIGNAL( startTransfer( Transfer* ) ) );

}
//-----------------------------------------------
KBearInfoView::~KBearInfoView(){
//	delete m_logView;
//	delete m_transferView;
}
//-----------------------------------------------
void KBearInfoView::connectCopyJob( KBearCopyJob* job ) {
	connect( job, SIGNAL( logMessage( const QString&, const QString& ) ),
			m_logView, SLOT( slotLogMessage( const QString&, const QString& ) ) );	
}
//-----------------------------------------------
int KBearInfoView::numOfTransfers() const {
	return m_transferView->numOfTransfers();
}
//-----------------------------------------------
bool KBearInfoView::canStartTransfer( const QString& name, const QString& other  ) {
	return m_transferView->canStartTransfer( name, other );
}
//-----------------------------------------------
void KBearInfoView::addLogPage( KBearMdiChildView* connectView, const QString& encoding ) {
	connect( connectView, SIGNAL( childWindowCloseRequest( QextMdiChildView* ) ),
				this, SLOT( slotChildWindowCloseRequest( QextMdiChildView* ) ) );
	connect( connectView, SIGNAL( logMessage( const QString&, const QString& ) ),
				m_logView, SLOT( slotLogMessage( const QString&, const QString& ) ) );
 	connect( connectView, SIGNAL( activated(QextMdiChildView*) ),
 				m_logView, SLOT( slotSetActiveLogTab( QextMdiChildView* ) ) );

	m_logView->addPage( connectView->connection().label() );
	m_logView->setEncoding( encoding );
}
//-----------------------------------------------
void KBearInfoView::removeLogPage( const QString& name ) {
	m_logView->removePage( name );
}
//-----------------------------------------------
void KBearInfoView::newTransfer( Transfer* t ) {
	m_transferView->addTransfer( t );
}
//-----------------------------------------------
void KBearInfoView::showLogView() {
	m_logView->youShouldBeVisible( true );
}
//-----------------------------------------------
void KBearInfoView::hideLogView() {
	m_logView->youShouldBeVisible( false );
}
//-----------------------------------------------
void KBearInfoView::showTransferView() {
	m_transferView->youShouldBeVisible( true );
}
//-----------------------------------------------
void KBearInfoView::hideTransferView() {
	m_transferView->youShouldBeVisible( false );
}
//-----------------------------------------------
void KBearInfoView::slotChildWindowCloseRequest( QextMdiChildView* view ) {
	removeLogPage( static_cast<KBearMdiChildView*>(view)->connection().label() );
//	removeTransferPage( view->name() );
}
//-----------------------------------------------
void KBearInfoView::slotLogShowing() {
	KDockWidget* dock = KBear::self()->manager()->findWidgetParentDock( this /*parentWidget()*/ );
	if( dock && dock->mayBeShow() )
		KBear::self()->makeDockVisible( dock );
	if( findTabByCaption( m_logView->caption() ) == -1 ) {
		addTab( m_logView, m_logView->caption() );
		showPage( m_logView );
	}
}
//-----------------------------------------------
void KBearInfoView::slotTransferShowing() {
	KDockWidget* dock = KBear::self()->manager()->findWidgetParentDock( this /*parentWidget()*/ );
	if( dock && dock->mayBeShow() )
		KBear::self()->makeDockVisible( dock );
	if( findTabByCaption( m_transferView->caption() ) == -1 ) {
		addTab( m_transferView, m_transferView->caption() );
		showPage( m_transferView );
	}
}
//-----------------------------------------------
void KBearInfoView::slotLogHiding() {
	KDockTabGroup::removePage( m_logView );
	if( m_transferView->isHidden() ) {
		KDockWidget* dock = KBear::self()->manager()->findWidgetParentDock( this /*parentWidget()*/ );
		if( dock && dock->mayBeHide() )
			KBear::self()->makeDockInvisible( dock );
	}
	else if( m_transferView->count() > 0 )
		showPage( m_transferView );
}
//-----------------------------------------------
void KBearInfoView::slotTransferHiding() {
	KDockTabGroup::removePage( m_transferView );
	if( m_logView->isHidden() ) {
		KDockWidget* dock = KBear::self()->manager()->findWidgetParentDock( this /*parentWidget()*/ );
		if( dock && dock->mayBeHide() )
			KBear::self()->makeDockInvisible( dock );
	}
	else if( m_logView->count() > 0 )
		showPage( m_logView );

	emit transfersFinished();
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbearinfoview.moc"
#endif
