/***************************************************************************
 *   Copyright (C) 2003 by Hans Karlsson                                   *
 *   karlsson.h@home.se                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "uptimesensor.h"

UptimeSensor::UptimeSensor( int interval ) : Sensor( interval )
{}
UptimeSensor::~UptimeSensor()
{}

void UptimeSensor::update()
{
    QFile file("/proc/uptime");
    QString line;
    if ( file.open(IO_ReadOnly | IO_Translate) )
    {
        // file opened successfully
        QTextStream t( &file );        // use a text stream
        line = t.readLine();         // line of text excluding '\n'
        file.close();

        QRegExp rx( "^\\d+" );
        rx.search(line);
        int uptime = rx.cap(0).toInt();
        int days = uptime / 86400;
        uptime -= days * 86400;
        int hours = uptime  / 3600;
        uptime -= hours * 3600;
        int mins = uptime / 60;
        uptime -= mins * 60;
        int secs = uptime;


        QString format;
        SensorParams *sp;
        Meter *meter;

        QObjectListIt it( *objList );
        while (it != 0)
        {
            sp = (SensorParams*)(*it);
            meter = sp->getMeter();
            format = sp->getParam("FORMAT");

            if (format.length() == 0 )
            {
                format = "%dd %h:%M";
            }
            format.replace( QRegExp("%d"), QString::number(days));
            format.replace( QRegExp("%H"), QString::number(hours).rightJustify(2,'0'));
            format.replace( QRegExp("%M"), QString::number(mins).rightJustify(2,'0'));
            format.replace( QRegExp("%S"), QString::number(secs).rightJustify(2,'0'));
            format.replace( QRegExp("%h"), QString::number(hours));
            format.replace( QRegExp("%m"), QString::number(mins));
            format.replace( QRegExp("%s"), QString::number(secs));

            meter->setValue(format);
            ++it;
        }
    }
}
