/***************************************************************************
 *   Copyright (C) 2003 by Hans Karlsson                                   *
 *   karlsson.h@home.se                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "graph.h"
#include <qstring.h>
Graph::Graph( int  x  , int y, int w, int h, int nbrPts) : Meter(x, y, w, h)
{

    nbrPoints = (nbrPts==0)? 50:nbrPts ;
    ptPtr = 0;
    values = new int[nbrPoints];
    for(int i = 0; i < nbrPoints; i++)
        values[i] = 0;
    minValue = 0;
    maxValue = 100;

}


Graph::~Graph()
{
    delete values;
}

void Graph::setValue( int v)
{
    if( v > maxValue)
    {
        // maxValue = v;
        v = maxValue;
    }
    if( v < minValue)
    {
        //minValue = v;
        v = minValue;
    }
    values[ptPtr] = (int) (v/ (maxValue+0.0001)*height);
    ptPtr = (ptPtr + 1) % nbrPoints;
}

void Graph::setValue( QString v )
{
    setValue( (int) (v.toDouble()  + 0.5) );
}

void Graph::setMin( int mv )
{
    minValue = mv;
}

void Graph::setMax( int mv )
{
    maxValue = mv;
}


void Graph::setColor(int r, int g, int b)
{
    color = QColor(r,g,b);
}


void Graph::mUpdate(QPainter *p)
{
    double step = (width / (nbrPoints-1.001));
    double xPos = 0;
    double nextXPos = 0;
    p->setPen(color);
    for (int i = 0; i < nbrPoints - 1 ; i ++)
    {
        nextXPos = xPos + step;
        p->drawLine(x + (int)xPos, y+height - (int) values[(ptPtr+i) % nbrPoints] ,
                    x + (int)nextXPos, y+height -  (int) values[(ptPtr + i +1) % nbrPoints] );
        xPos = nextXPos;
    }
}
