
/*
 * Kanatest
 *
 * Copyright (C) 2001 Tomasz Mka
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define config_filename 	"kanatest"

#define P_READ			1
#define P_WRITE			2

#define null_char		'\0'
#define crlf_char		'\n'
#define space_char		' '
#define comma_char		','
#define under_char		'_'
#define slash 			"/"
#define space 			" "
#define crlf			"\n"
#define dot				"."

#define MAX_LINE_LEN	4096
#define MAX_VALUE_LEN	2048

#define MAX_PATH 		1024

gchar*		s_strcpy		(gchar *dest, const gchar *src, guint maxlength);
gchar*		s_strcat		(gchar *dest, const gchar *src, guint maxlength);

#define katakana_dir	"/katakana/"
#define hiragana_dir	"/hiragana/"
#define romaji_dir		"/romaji/"

struct jpprefs
{
	gchar		data_path[MAX_PATH];
	gint		window_x;
	gint		window_y;
	gint		window_size_x;
	gint		window_size_y;
	gint		stat_window_x;
	gint		stat_window_y;
	gint		about_window_x;
	gint		about_window_y;
	gint		last_mode;
	gint		repeat_wrong;
	gfloat		t_time;
	gint		run_counter;
	gint		hiragana_counter;
	gint		katakana_counter;
	gint		mixed_counter;
	gint		hiragana_max_result;
	gint		katakana_max_result;
	gint		mixed_max_result;
	gfloat		hiragana_time;
	gfloat		katakana_time;
	gfloat		mixed_time;
};

void	read_config		(void);
void	write_config	(void);


