/***************************************************************************
                           kaffeineapp.cpp
                             -------------------
    begin                : Die Mai 13 2003
    revision             : $Revision: 1.21 $
    last modified        : $Date: 2005/02/02 10:08:17 $ by $Author: juergenk $
    copyright            : (C) 2003-2005 by Jürgen Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kdebug.h>
#include <kwin.h>

#include <qfile.h>
#include <qtimer.h>
#include <qdir.h>

#include "kaffeineapp.h"


KaffeineApp::KaffeineApp() : KUniqueApplication(), m_kaffeine(0)
{
}

KaffeineApp::~KaffeineApp()
{
  delete m_kaffeine;
}

int KaffeineApp::newInstance()
{
 /*
  * FIXME: session management make lot of troubles; because kaffeine starts more than one process?
  * disabled for the moment...
  */ 

  if (isRestored())
  {
    //RESTORE(Kaffeine);
    //return 0;
    exit(0);
  }

  /* parse command line options */
  KCmdLineArgs* args = KCmdLineArgs::parsedArgs();
  QStringList urls;
  QString url;
  QDir path;
  if (args->count())
     for (int i = 0; i < args->count(); i++ )
     {
       url = QFile::decodeName(args->arg(i));
       // relative file names
       if ((url.left(1) != "/") && (!url.contains(":/")) && (url.lower() != "dvd") && (url.lower() != "vcd")
           && (url.lower() != "audiocd") && (url.lower() != "cdda")) 
          url = path.absFilePath(url);
       urls.append(url);
     }
   
  if (m_kaffeine)  /* still running */
  {
    kdDebug() << "KaffeineApp: Kaffeine is still running..." << endl;
    if (urls.count() > 0)  /* send urls to running instance */
    {
       m_kaffeine->loadTMP(urls);
       QTimer::singleShot(300, m_kaffeine, SLOT(slotSwitchToPlayerWindow())); // delay for feeling only
    }  
    m_kaffeine->show(); 
    KWin::activateWindow(m_kaffeine->winId());
    return 0; 
 }  

 /* start kaffeine */
  QStringList engineParameters;
  if (args->getOption("audiodriver") != "default")
    engineParameters.append("audioDriver=\"" + args->getOption("audiodriver") + "\"");
  if (args->getOption("videodriver") != "default")
    engineParameters.append("videoDriver=\"" + args->getOption("videodriver") + "\"");  
  if (args->isSet("verbose"))
    engineParameters.append("verbose=\"True\"");  
 
  QString device = args->getOption("device");
  if (device == "default")
    device = QString::null;  
 
  m_kaffeine = new Kaffeine(urls, engineParameters, device, args->isSet("play"), args->isSet("fullscreen"), 
                            args->isSet("wizard"), 0, "kaffeine_mainview");
  m_kaffeine->show();
  return 0;
}



