/***************************************************************************
                          sender.cpp  -  description
                             -------------------
    begin                : Wed Feb 5 2003
    copyright            : (C) 2003-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/02/02 10:08:25 $ by $Author: juergenk $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kmessagebox.h>
#include <klocale.h>

#include "sender.h"



Sender::Sender( bool *ok )
{
	int sockopt=1;

	isRunning = false;

	if ( ( senderSocket = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
		KMessageBox::information( 0, "Can't open sender socket.", i18n("Warning") );
		*ok = false;
	}

	senderAddr.sin_family = AF_INET;         // host byte order
	senderAddr.sin_port = htons( 1235 );     // short, network byte order
	senderAddr.sin_addr.s_addr = inet_addr( "192.168.0.255" );

	memset( &( senderAddr.sin_zero ), '\0', 8 ); // zero the rest of the struct

	if ( setsockopt( senderSocket, SOL_SOCKET, SO_BROADCAST, &sockopt, sizeof(sockopt) ) < 0 ) {
		KMessageBox::information( 0, "Can't open sender socket.", i18n("Warning") );
		*ok = false;
	}

	currentList = "\n";
}



Sender::~Sender()
{
	//if ( sock>0 ) close(sock);
}



void Sender::run()
{
	while( isRunning ) {
		sendto( senderSocket, currentList.latin1(), currentList.length(), 0, (struct sockaddr *)&senderAddr, sizeof(senderAddr) );
		msleep(500);
	}
}



void Sender::go()
{
	isRunning = true;
	start();
}



void Sender::stop()
{
	isRunning = false;
	wait();
	sendto( senderSocket, "quit\n", 5, 0, (struct sockaddr *)&senderAddr, sizeof(senderAddr) );
}



void Sender::setList( QString list )
{
	currentList = list;
}
