# -*- perl -*-

use strict;
use Test;

BEGIN { plan tests => 8 }

use Juman::Morpheme;

unless( eval { require DB_File; } ){
    print STDERR "DB_File is missing.  Skip all tests.\n";
    for( 1 .. 8 ){
	print "ok\n";
    }
    exit 0;
}

my $mrph = Juman::Morpheme->new( "ư  ư ư 2 * 0 Ҳư쥫 2 ̤ 3\n" );
ok(defined $mrph);

my $new = $mrph->change_katuyou2( '¸ߤʤѷ' );
ok(!defined $new);

$new = $mrph->change_katuyou2( '̿' );
ok(defined $new);
ok($new->midasi() eq 'ư' );
ok($new->katuyou2_id == 5);

$new = $mrph->kihonkei();
ok(defined $new);
ok($new->midasi() eq 'ư' );
ok($new->katuyou2_id == 2);
