#*****************************************************************************
#*                            WaveWidget.tcl
#*
#* Author: Matthew Ballance
#* Desc:   Implements the TCL initialization functionality...
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#*****************************************************************************

package provide wave_widget

#********************************************************************
#* WaveWidget_Register
#********************************************************************
proc WaveWidget_Register args {

     MenuMgr::append "IviUi::Main.File.New" \
        command "&Waveform Window" ( -command "lookup_wave -win new_auto" )
}

#********************************************************************
#* wave_widget_Init
#********************************************************************
proc wave_widget_Init { } {
    global IVI_HOME

    DialogMgr::load \
        [file join $IVI_HOME modules wave_widget WaveDialogs.dlt]

    MenuMgr::load \
        [file join $IVI_HOME modules wave_widget WaveMenus.mtf]

    callback add App.Register null WaveWidget_Register
}


