/****************************************************************************
 *                             StubFilter.h
 *
 *
 * Author: Matthew Ballance
 * Desc:   Implements the DFIOFilter API for files generated by the Stub
 *         DFIO. (simple dump format)
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "DFIOFilter.h"
#include "vector.h"
#include <stdio.h>
#include "FileAccObj.h"

class DFIO;
class DFIOTrace;
class StubFilter : public DFIOFilter {

    public:
        StubFilter(Tcl_Interp *interp);

        virtual Int32 isValidFile(FileAccObj &file);
        virtual Int32 Export(DFIO **dfio, FileAccObj &file);
        virtual Int32 Import(DFIO **dfio, FileAccObj &file);

    private:
        FileAccObj            file;
        DFIO                 *data;
        Uint32                max_trace_width;
        Vector<DFIOTrace>    *trace_vector;

        Uint32                tmp_buf_len;
        UChar                *tmp_buf;

        Uint32                str_buf_len;
        Char                 *str_buf;

        enum {
            BIT_VAL_0 = 0,
            BIT_VAL_1 = 1,
            BIT_VAL_Z = 2,
            BIT_VAL_X = 3
        };

       
        inline UChar char_to_bval(Char val) { 
            return (val == '0')?BIT_VAL_0:
                   (val == '1')?BIT_VAL_1:
                   (val == 'Z' || val == 'z')?BIT_VAL_Z:
                   (val == 'X' || val == 'x')?BIT_VAL_X:BIT_VAL_X;
        }

        inline UChar bval_to_char(UChar bval) {
            return "01ZX"[bval&3];
        }

        void dump_traces();
        int  read_traces();
        int  read_trace_data();

        inline void dump_string(const char *str, Int32 len) {
            if (len < 0) {
                len = strlen(str);
            }
            file.write_uint32(len);
            file.write_bytes((Uint8 *)str, len);
        }

        inline void read_string(String &str) {
            Uint32 len;
            file.read_uint32(&len);

            str.chkSize(len+1);

            file.read_bytes((Uint8 *)str.value(), len);
            str[len] = 0;
        }



        void dump_trace_data();
};



