#****************************************************************************
#*                           StdConsole.tcl
#*
#* Author: Matthew Ballance
#* Desc:
#****************************************************************************

namespace eval StdConsole {


}

#********************************************************************
#* StdConsole
#********************************************************************
proc StdConsole::StdConsole {path args} {


    proc ::$path {cmd args} "return \[eval StdConsole::cmd $path \$cmd \$args\]"

    array set $path {_dummy _dummy}
    upvar #0 $path data

    set data(input_buffer) ""

    fileevent stdin readable [list StdConsole::StdinProc $path]
    fconfigure stdin -blocking false -buffering none
    fconfigure stdout -buffering none

    ConsoleMgr::AddConsole $path

    Prompt $path
}

#********************************************************************
#* cmd
#********************************************************************
proc StdConsole::cmd {path cmd args} {
    upvar #0 $path data

    switch $cmd {

        print_line {
            print_line [lindex $args 0]
        }

        default {
            error "unknown StdConsole command \"$cmd\""
        }
    }
}

#********************************************************************
#* print_line
#********************************************************************
proc StdConsole::print_line {str} {
    puts stdout $str
}

#********************************************************************
#* StdinProc
#********************************************************************
proc StdConsole::StdinProc {path} {
    upvar #0 $path data

    set line $data(input_buffer)
    while {1} {
        set chars [gets stdin tmpline]

        if {$chars <= 0} {
            break
        }

        set line "$line $tmpline"

        if {[string trimleft $line] == "" || \
                [string trimright $line] == ""} {
            continue
        } 

        if {[info complete $line]} {
            if {[catch {ConsoleMgr::RunConsoleCmd $path $line} res]} {
            }
            set line ""
            Prompt $path
        } else {
            Prompt2 $path
        }
    }

    set data(input_buffer) $line
}

#********************************************************************
#* Prompt
#********************************************************************
proc StdConsole::Prompt {path} {
    upvar #0 $path data

    puts -nonewline "% "
}

#********************************************************************
#* Prompt2
#********************************************************************
proc StdConsole::Prompt2 {path} {
    upvar #0 $path data

    puts -nonewline "=> "
}
