#****************************************************************************
#*                             iviAboutWindow
#* Author: Matthew Ballance
#* Desc:   Implements a simple 'About' window...
#*
#*
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#*
#*
#****************************************************************************

#********************************************************************
#* IviAbout
#********************************************************************
namespace eval IviAbout {
    variable configspec {
        {-splash    ""}
        {-filename  ""}
    }
}

#*********************************************************
#* ConstructWidget
#*********************************************************
proc IviAbout::IviAbout {path args} {
   global   IVI_HOME
   variable configspec

   set w [toplevel $path]

   array set $path {_dummy _dummy}
   upvar #0 $path data

   foreach spec $configspec {
       set data([lindex $spec 0]) [lindex $spec 1]
   }

   eval BaseClass::configure $path $args

   #******************************************************
   #* Create info frame
   #******************************************************
   image create photo splash -file \
       [file join $IVI_HOME modules ivi_ui ivi_splash_0.3.gif]
   set data(w:info_frame) [frame $w.info_frame -width 300 -height 320]
   set data(w:splash) [label $data(w:info_frame).splash -image splash]

   set data(w:cr_frame) \
       [ScrollContainer::ScrollContainer $data(w:info_frame).cr_frame]
   set cr_frame $data(w:cr_frame)


   set scont [$data(w:cr_frame) subwidget frame]

   # -width 300 -height 320
    set data(w:credits) [text $scont.text -bg grey95 -width 16 -height 8]

    set vsb [$data(w:cr_frame) subwidget vsb]
    set hsb [$data(w:cr_frame) subwidget hsb]

    $data(w:credits) configure -yscrollcommand "$vsb set"
    $data(w:credits) configure -xscrollcommand "$hsb set"

    $vsb configure -command "$data(w:credits) yview"
    $hsb configure -command "$data(w:credits) xview"

    pack $data(w:credits) -expand yes -fill both
    pack $data(w:splash) -expand yes -fill both

    #******************************************************
    #* Create button frame
    #******************************************************
    set data(w:button_frame) [frame $w.button_frame]
    set data(w:close_button) [button $data(w:button_frame).close \
       -text "Close" -command "destroy $w" ]
    set data(w:credits_button) [button $data(w:button_frame).credits \
       -text "Credits" -command "IviAbout::Credits $w" ]
    set data(w:splash_button) [button $data(w:button_frame).splash \
       -text "Splash" -command "IviAbout::Splash $w"]
    pack $data(w:close_button) $data(w:credits_button) $data(w:splash_button) \
       -side left -expand yes

   pack $data(w:info_frame) -side top -expand yes -fill both
   pack $data(w:button_frame) -side top

   update
   set g [winfo geometry $w]

   pack $data(w:cr_frame) -in $data(w:splash) -expand yes -fill both

   Splash $path
   SetCredits $path

   Splash $path

   wm geometry $w $g
}

#********************************************************************
#* SetCredits
#********************************************************************
proc IviAbout::SetCredits {w} {
    upvar #0 $w data

    set tw $data(w:credits)
    $tw config -state normal

    set credits ""
  
    if {[file readable $data(-filename)]} {
        set fileid  [open $data(-filename) "r"]
        set credits [read $fileid]
        close $fileid
    }

    if {$credits != ""} {
        $tw delete 1.0 end
        $tw insert end $credits
    }

    $tw config -state disabled
}

#*********************************************************
#* Credits
#*********************************************************
proc IviAbout::Credits {w} {
    upvar #0 $w data

    raise $data(w:cr_frame) $data(w:splash)
    wm title $w "About IVI - Credits"
}

#*********************************************************
#* Splash
#*********************************************************
proc IviAbout::Splash {w} {
    upvar #0 $w data

    raise $data(w:splash) $data(w:cr_frame)
    wm title $w "About IVI - Version [get_ivi_version]"
}

#*********************************************************
#* Destroy
#*********************************************************
proc IviAbout::Destroy {w} {
   upvar #0 $w data
   destroy $w
}


