/****************************************************************************
 *                           IviRemoteSDBSrv.cc
 *
 * Author: Matthew Ballance
 * Desc:   Implements the Server (IVI) side of the SDB
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "IviRemoteSDBSrv.h"
#include "IviRemoteProto.h"
#include "RemoteAppConnectionListener.h"
#include "IviRemoteSDBProto.h"
#include "ShmDFIOReader.h"
#include "DFIO.h"
#include <string.h>
#include <unistd.h>


class IviRemoteSDBSrvListener : public RemoteAppConnectionListener {

    public:

        IviRemoteSDBSrvListener(IviRemoteSDBSrv *sdb_srv) :
            RemoteAppConnectionListener(REMOTE_SDB_IDX)
        {
            d_sdbSrv = sdb_srv;
        }

        virtual void Receive(Uint32 idx, Uint32 len, Uchar *data)
        {
            d_sdbSrv->Receive(len, data);
        }

    private:
        IviRemoteSDBSrv      *d_sdbSrv;
};


/*******************************************************************
 * IviRemoteSDBSrv()
 *******************************************************************/
IviRemoteSDBSrv::IviRemoteSDBSrv(
        RemoteAppConnection         *conn,
        Tcl_Interp                  *interp,
        Uint32                       argc,
        Char                       **argv) : 
    SigDB(interp, argc, argv)
{
    d_conn = conn;

    d_len  = 0;
    d_data = 0;

    d_listener = new IviRemoteSDBSrvListener(this);
    d_conn->AddListener(d_listener);
}

/*******************************************************************
 * ~IviRemoteSDBSrv()
 *******************************************************************/
IviRemoteSDBSrv::~IviRemoteSDBSrv()
{

}

/*******************************************************************
 * addSignal()
 *
 * Sends the 'add-signal' command to the client. 
 * Sends a list of signal-names in response.
 *******************************************************************/
Vector<DFIOTrace> *IviRemoteSDBSrv::addSignal(Char *path)
{
    Uint32                    idx=0, i;
    Uchar                     buf[1024];
    char                     *p, *n;
    DFIO                     *dfio = getDFIO();
    DFIOTrace                *trace;

    RemoteAppConnection::WriteUint32(IviRemoteSDB_AddSignal, buf, idx);
    strcpy((char *)&buf[idx], path);
    idx += (strlen(path));
    buf[idx++] = 0;

    d_conn->Send(REMOTE_SDB_IDX, idx, buf);

    d_recv = 0;

    do {
        d_conn->Poll(0);
    } while (!d_recv);

    /**** Now, we must find the new DFIOTrace objects that we added... 
     ****/
    p = n = (char *)d_data;

    traceVector->empty();

    while (p) {
        if ((n = strchr(p, ','))) {
            *n = 0;
        }

        if (*p) {
            /**** Append to the list ****/
            if ((trace = dfio->findTrace(p))) {
                traceVector->append(trace);

                /**** See if the trace is already on the trace list ****/
                for (i=0; i<d_traces.length(); i++) {
                    if (d_traces.idx(i) == trace) {
                        break;
                    }
                }

                if (i == d_traces.length()) {
                    d_traces.append(trace);
                }
            } else {
                fprintf(stderr, "ERROR: Cannot find trace \"%s\" in DFIO\n", p);
#ifndef __MINGW32__
                usleep(100);
#endif

                if ((trace = dfio->findTrace(p))) {
                    fprintf(stderr, "\tAfter sleep, found signal\n");
                } else {
                    fprintf(stderr, "\tERROR: After sleep - no signal\n");
                }
            }
        }

        if (n) {
            p = n+1;
        } else {
            p = n;
        }
    }

    return traceVector;
}

/*******************************************************************
 * Receive()
 *
 * Used to receive the add-signals response from the client
 *******************************************************************/
void IviRemoteSDBSrv::Receive(Uint32 len, Uchar *data)
{
    d_recv = 1;

    if (len > d_len) {
        if (d_data) {
            delete [] d_data;
        }

        d_data = new Uchar[len];
        d_len  = len;
    }

    memcpy(d_data, data, len);
}


