/****************************************************************************
 *                           GhdlRemoteSimInit.cc
 *
 * Author: Matthew Ballance
 * Desc:   Entry-point functions. These are called by the IVI runtime during
 *         startup.
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include <tcl.h>
#include "GhdlRemoteSimInfo.h"
#include "SimMgr.h"

/********************************************************************
 * Ghdl_remote_sim_Init()
 ********************************************************************/
extern "C" int Ghdl_remote_sim_Init(Tcl_Interp *interp)
{
    GhdlRemoteSimInfo     *simInfo;
    simInfo = new GhdlRemoteSimInfo(interp);

    SimMgr_RegisterSim(simInfo);
    return TCL_OK;
}

/********************************************************************
 * Ghdl_remote_sim_SafeInit()
 ********************************************************************/
extern "C" int Ghdl_remote_sim_SafeInit(Tcl_Interp *interp)
{
    return Ghdl_remote_sim_Init(interp);
}

