#****************************************************************************
#*                               GhdlCmd.tcl
#*
#* Author: Matthew Ballance
#* Desc:   Implements commands for the GHDL compiler
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#****************************************************************************

namespace eval GhdlCmd {

    namespace export ghdl

}


#********************************************************************
#* Init
#********************************************************************
proc GhdlCmd::Init {} { 

}

#********************************************************************
#* ghdl
#********************************************************************
proc GhdlCmd::ghdl args {
    variable d_msgBuf

    #*** ivi_exec expects a list of arguments as its
    #*** sole parameter. Currently, we just need to insert
    #*** 'ghdl' before the existing list of args
    set args [linsert $args 0 ghdl]

    set ret [IviProc::ivi_exec $args]
}

#********************************************************************
#* mv
#********************************************************************
proc GhdlCmd::mv {src dest} {
    file rename -force $src $dest
}

#********************************************************************
#* cp
#********************************************************************
proc GhdlCmd::cp {src dest} {
    file copy $src $dest
}

#********************************************************************
#* 
#********************************************************************
proc GhdlCmd::mkdir {dir} {
    file mkdir $dir
}

namespace import GhdlCmd::*
