/****************************************************************************
 *                            CverDesignDB.h
 *
 * Author: Matthew Ballance
 * Desc:
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_CVER_DESIGN_DB_H
#define INCLUDED_CVER_DESIGN_DB_H
#include "DesignDB.h"

class CverDesignDB : public DesignDB {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * CverDesignDB()
         ************************************************************/
        CverDesignDB(
                Tcl_Interp           *interp,
                int                   argc,
                char                **argv);

        /************************************************************
         * ~CverDesignDB()
         ************************************************************/
        virtual ~CverDesignDB();

        /************************************************************
         * scanDesign()
         ************************************************************/
        virtual void scanDesign();

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:

        /*********************************************************
         * cverScanModule()
         *********************************************************/
        TreeNode *cverScanModule(
                TreeNode      *parent, 
                vpiHandle      modHndl);
        /*********************************************************
         * cverScanSignal()
         *********************************************************/
        TreeNode *cverScanSignal(TreeNode *parent, 
                vpiHandle sigHndl, Uint32    sigType);
};

#endif /* INCLUDED_CVER_DESIGN_DB_H */
