/*****************************************************************************
 *                             tree_field.cc
 * Author: Matthew Ballance
 * Desc:   Implements a tree field...
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 *****************************************************************************/
#include "tree_field.h"


/************************************************************
 * TreeField(char *fieldName, char *initValue)
 ************************************************************/
TreeField::TreeField(char *fieldName, char *initValue)
{
    this->fieldName = new String(fieldName);
    this->fieldValue = new String(initValue);
    this->fieldVoidVal = 0;
}

/************************************************************
 * TreeField(char *fieldName, void *initValue)
 ************************************************************/
TreeField::TreeField(char *fieldName, void *initValue)
{
    this->fieldName = new String(fieldName);
    this->fieldValue = new String("");
    this->fieldVoidVal = initValue;
}

/************************************************************
 * TreeField(TreeField *)
 ************************************************************/
TreeField::TreeField(TreeField *templ)
{

    this->fieldName = new String(templ->fieldName);
    this->fieldVoidVal = templ->getVoidVal();
    if (templ->getStringVal() != 0) {
        this->fieldValue = new String(templ->getStringVal());
    } 
}

