
#ifndef INCLUDED_TCL_CONFIG_H
#define INCLUDED_TCL_CONFIG_H

#ifdef __cplusplus
extern "C" {
#endif

Tk_OptionTable Tcl_CreateOptionTable(
        Tcl_Interp            *interp,
        const Tk_OptionSpec   *templatePtr);

void       Tcl_DeleteOptionTable(
        Tk_OptionTable         optionTable);

int        Tcl_SetOptions(
        Tcl_Interp            *interp,
        char                  *recordPtr,
        Tk_OptionTable         optionTable,
        int                    objc,
        Tcl_Obj               *const objv[],
        Tk_SavedOptions       *savePtr,
        int                   *maskPtr);

void       Tcl_RestoreSavedOptions(
        Tk_SavedOptions       *savePtr);

void       Tcl_FreeSavedOptions(
        Tk_SavedOptions       *savePtr);

void       Tcl_FreeConfigOptions(
        char                 *recordPtr,
        Tk_OptionTable       optionTable);

Tcl_Obj   *Tcl_GetOptionInfo(
        Tcl_Interp           *interp,
        char                 *recordPtr,
        Tk_OptionTable        optionTable,
        Tcl_Obj              *namePtr);

Tcl_Obj   *Tcl_GetOptionValue(
        Tcl_Interp           *interp,
        char                 *recordPtr,
        Tk_OptionTable        optionTable,
        Tcl_Obj              *namePtr);

int Tcl_InitOptions(
        Tcl_Interp        *interp, 
        char              *recordPtr, 
        Tk_OptionTable     optionTable);

#ifdef __cplusplus
};
#endif

#endif /* INCLUDED_TCL_CONFIG_H */

