/****************************************************************************
 *                            XObjWidgetBase.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a base class for X widgets. All widget-type instances
 *         are derived from this class... 
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_XWIDGET_OBJ_BASE_H
#define INCLUDED_XWIDGET_OBJ_BASE_H
#include "ObjWidgetBase.h"
#include "GCObj.h"
#include "XPixmapObj.h"
#include <tk.h>

class CallbackList;
class XObjWidgetBase : public ObjWidgetBase {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:
        /************************************************************
         * XObjWidgetBase()
         ************************************************************/
        XObjWidgetBase(
                Tcl_Interp         *interp,
                Uint32              objc,
                Tcl_Obj            *const objv[]);

        /************************************************************
         * ~XObjWidgetBase()
         ************************************************************/
        virtual ~XObjWidgetBase();

        /************************************************************
         * Destroy()
         ************************************************************/
        static void Destroy(char *ptr);

        /************************************************************
         * EventProc
         ************************************************************/
        virtual void EventProc(XEvent *eventPtr);

        /************************************************************
         * InstCmd()
         ************************************************************/
        virtual int InstCmd(
                Tcl_Interp         *interp,
                Uint32              objc,
                Tcl_Obj            *const objv[]) {
            return base_InstCmd(interp, objc, objv);
        }

        /************************************************************
         * IdleProc()
         ************************************************************/
        virtual void IdleProc();

        /************************************************************
         * SetupRedraw()
         ************************************************************/
        virtual void SetupRedraw(Uint32 redraw_flags);

        /************************************************************
         * SetupRedraw()
         ************************************************************/
        virtual void SetupRedraw() { SetupRedraw(0); }

        /************************************************************
         * SetFlag()
         ************************************************************/
        void SetFlag(Uint32 flags) { d_RedrawFlags |= flags; }

        /************************************************************
         * IsFlagSet()
         ************************************************************/
        bool IsFlagSet(Uint32 flags) const { return (d_RedrawFlags & flags); }

        /************************************************************
         * ClrFlag()
         ************************************************************/
        void ClrFlag(Uint32 flags) { d_RedrawFlags &= (~flags); }

        /************************************************************
         * winValid()
         ************************************************************/
        int winValid();

        /************************************************************
         * getWin()
         ************************************************************/
        inline Tk_Window getWin() const { return d_mainWindow; }

        /************************************************************
         * getDisplay()
         ************************************************************/
        inline Display *getDisplay() const { return d_display; }

        /************************************************************
         * width()
         ************************************************************/
        inline Uint32 width() const { return Tk_Width(d_mainWindow); }

        /************************************************************
         * height()
         ************************************************************/
        inline Uint32 height() const { return Tk_Height(d_mainWindow); }

        /************************************************************
         * UpdateScrollbar()
         *
         * Issues the appropriate scroll command given the specified
         * parameters...
         ************************************************************/
        void UpdateScrollbar(
                char     *cmd, 
                Uint32    start_pos,
                Uint32    visible_height,
                Uint32    total_height);

        /************************************************************
         * ProcessViewCmd
         ************************************************************/
        int ProcessViewCmd(
                Uint32        objc,
                Tcl_Obj      *const objv[],
                Uint32        display_total,
                Uint32        display_visible,
                Uint32       &display_start);

        /************************************************************
         * Center()
         ************************************************************/
        void Center(
                Uint32        displayStart,
                Uint32        displaySize,
                Uint32       &pixmapStart,
                Uint32        pixmapSize);

        /************************************************************
         * Bind()
         ************************************************************/
        int Bind(
                const char        *bindtag,
                const char        *argPattern,
                Tcl_ObjCmdProc    *cmdProc,
                ClientData         userData);


        /************************************************************
         * XWidgetInit()
         ************************************************************/
        static int XWidgetInit(
                Tcl_Interp        *interp,
                const char        *WidgetName,
                const char        *WidgetVersion,
                const char        *WidgetCmd,
                Tcl_ObjCmdProc    *cmdProc);

    /****************************************************************
     * Public Data
     ****************************************************************/
    public:

    /****************************************************************
     * Protected Methods
     ****************************************************************/
    protected:

        enum {
            RedrawPending    = 0x0001,
            RedrawForce      = 0x0002,
            RedrawNumFlags   = 0x0004
        };

        Uint32        d_RedrawFlags;

        /************************************************************
         * base_SetupRedraw()
         ************************************************************/
        void base_SetupRedraw(Uint32 redraw_flags);


    /****************************************************************
     * Protected Methods
     ****************************************************************/
    protected:
        XPixmapObj     d_WinPixmap;

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * InstCmd()
         ************************************************************/
        static int InstCmd(
                ClientData         clientData,
                Tcl_Interp        *interp,
                int                objc,
                Tcl_Obj           *const objv[]);

        static void IdleProc(ClientData clientData);

        int base_InstCmd(
                Tcl_Interp         *interp,
                Uint32              objc,
                Tcl_Obj            *const objv[]);

        /************************************************************
         * EventProc()
         ************************************************************/
        static void EventProc(ClientData clientData, XEvent *eventPtr);

        /************************************************************
         * ProcessEvents()
         ************************************************************/
        void ProcessEvents(XEvent *eventPtr);

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        Tk_Window     d_mainWindow;
        Display      *d_display;

        CallbackList *d_MotionCbList;
        CallbackList *d_BPCbList;
        CallbackList *d_BRCbList;

        CallbackList *d_BDPCbList;

        Uint32        d_PageMoveNumerator;
        Uint32        d_PageMoveDenominator;
        Uint32        d_PageScrollUnitMult;
        Uint32        d_YscrollOvershoot;

        Tcl_Obj      *cbArgs[16];
        Uint32        d_buttonTimes[16];
        Uint32        d_bindCnt;
};

#endif /* INCLUDED_XWIDGET_OBJ_BASE_H */

