/*****************************************************************************
 *                             TclListObj.cc
 *
 * Author: Matthew Ballance
 * Desc:   Implements c++ wrapper around a TCL list object
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *****************************************************************************/
#ifndef INCLUDED_TCL_LIST_OBJ_H
#define INCLUDED_TCL_LIST_OBJ_H
#include "ivi_String.h"
#include "types.h"
#include <tcl.h>

class TclListObj {
    public:
        TclListObj(Tcl_Interp *interp);
        TclListObj(Tcl_Interp *interp, Tcl_Obj *list);

        TclListObj operator << (Uint32 val);
        TclListObj operator << (Int32  val);
        TclListObj operator << (const Char  *val);
        TclListObj operator << (const String  &val);
        TclListObj operator << (const TclListObj &val);
        TclListObj operator << (Tcl_Obj *const val);
        Tcl_Obj   *operator [] (Uint32 idx);

        void       operator () (Tcl_Interp *interp);

        void append_elems(Tcl_Obj *obj);
        void append_elems(int objc, Tcl_Obj *const vals[]);
        Uint32     length();

        Tcl_Obj *end(void);

    private:
        Tcl_Interp *interp;
        Tcl_Obj    *obj;

};

#endif /* INCLUDED_TCL_LIST_OBJ_H */
