/****************************************************************************
 *                             TclBitVector.h
 *
 * Author: Matthew Ballance
 * Desc:   
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 ****************************************************************************/
#ifndef INCLUDED_TCL_BITVECTOR_H
#define INCLUDED_TCL_BITVECTOR_H
#include "DFIOValChg.h"

#ifdef __cplusplus
extern "C" {
class BitVector;
#endif

/****************************************************************************
 * Tcl_NewBitVector_Str()
 ****************************************************************************/
Tcl_Obj *Tcl_NewBitVector_Str(char *str, Int32 len);

/****************************************************************************
 * Tcl_NewBitVector_BinStr()
 ****************************************************************************/
Tcl_Obj *Tcl_NewBitVector_BinStr(char *str, Int32 len);

/****************************************************************************
 * Tcl_GetBitVectorFromObj()
 ****************************************************************************/
int Tcl_GetBitVectorFromObj(
        Tcl_Interp        *interp,
        Tcl_Obj           *obj,       /**** Input            ****/
        BitVector        **out);      /**** BitVector output ****/

/****************************************************************************
 * Tcl_NewBitVector_DFIOVal()
 ****************************************************************************/
Tcl_Obj *Tcl_NewBitVector_DFIOVal(DFIOVal *value, Uint32 bitLen);

#ifdef __cplusplus
};
#endif

#endif /* INCLUDED_TCL_BITVECTOR_H */
