/****************************************************************************
 *                           StimTraceRdr.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a trace reader... Reads values from the specified
 *         trace and drives them onto a signal...
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_STIM_TRACE_RDR_H
#define INCLUDED_STIM_TRACE_RDR_H
#include "types.h"
#include "vpi_user.h"

class DFIOTrace;
class StimulusMgr;
class IviSim;
class StimTraceRdr {
    public:
        StimTraceRdr(
                vpiHandle      simSignal,
                DFIOTrace     *trace_data,
                StimulusMgr   *mgr);
       ~StimTraceRdr();

        /************************************************************
         * Start()
         * Begins
         ************************************************************/
        void Start();

        Uint32 get_maxTime() const { return d_maxTime; }
        void set_maxTime(Uint32 maxTime) { d_maxTime = maxTime; }

        Uint32 get_maxTrans() const { return d_maxTrans; }
        void set_maxTrans(Uint32 maxTrans) { d_maxTrans = maxTrans; }

        Int32 get_Offset() const { return d_offset; }
        void  set_Offset(Int32 offset) { d_offset = offset; }

    private:
        DFIOTrace        *d_trace;
        StimulusMgr      *d_mgr;
        vpiHandle         d_vpiHndl;
        Uint32            d_maxTime;
        Uint32            d_maxTrans;
        Int32             d_offset;

        Uint32            d_startTime;
        Uint32            d_traceTime;
        /**** Holds the time for the next (current) transition... This time
         **** is expressed in trace time. 
         ****/

        Uint32            d_sigwidth;

        s_cb_data         cb_data;
        s_vpi_time        cb_time;

        IviSim           *sim;

        static int StimTraceRdr::DataCB(p_cb_data  cb_data_p);
};

#endif /* INCLUDED_STIM_TRACE_RDR_H */

