/****************************************************************************
 *                            StimSeqDraw.h
 ****************************************************************************/
#ifndef INCLUDED_STIM_SEQ_DRAW_H
#define INCLUDED_STIM_SEQ_DRAW_H
#include "StimSeqInst.h"
#include "StimulusItem.h"
#include "StimulusSeq.h"
#include "StimulusMgr.h"
#include "DFIOTrace.h"
#include "Stack.h"
#include <memory.h>

class StimSeqDraw {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:
        /************************************************************
         * StimSeqDraw()
         ************************************************************/
        StimSeqDraw();

        /************************************************************
         * StimSeqDraw()
         ************************************************************/
        StimSeqDraw(
                DFIOTrace         *trace,
                StimulusSeq       *seq,
                Uint32             maxTime);

        /************************************************************
         * operator ()
         ************************************************************/
        void operator () (
                DFIOTrace         *trace,
                StimulusSeq       *seq);

        void Draw(Uint32 max);
        int DrawHelper();

    /****************************************************************
     * Public Data
     ****************************************************************/
    public:

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * setup()
         ************************************************************/
        void setup(
                DFIOTrace         *trace,
                StimulusSeq       *seq,
                Uint32             maxTime);

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:

        enum OutModeType {
            ModeOutput,
            ModeDelay,
            ModeRepeatDelay,
            ModeSetupNext
        };

        DFIOTrace             *d_trace;
        StimulusSeq           *d_seq;
        Uint32                 d_maxTime;
        Stack<StimSeqLevel>    d_levStack;
        Uint32                 d_repeatCnt;
        Uint32                 d_width;
        OutModeType            d_outMode;
        Uint32                 d_currTime;
};

#endif /* INCLUDED_STIM_SEQ_DRAW_H */
