/****************************************************************************
 *                              SimMgr.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a manager for multiple Simulators
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_Sim_MGR_H
#define INCLUDED_Sim_MGR_H
#include "SimInfo.h"
#include "vector.h"

#ifdef __cplusplus
extern "C" {
#endif


/****************************************************************************/
/** \class SimMgr 
 *  \brief Contains details on the available simulators
 ****************************************************************************/
class SimMgr {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * SimMgr()
         */
        /** 
         ************************************************************/
        SimMgr();

        Vector<SimInfo>        *simList;

        /************************************************************
         * GetSimMgr()
         */
        /**
         ************************************************************/
        static SimMgr          *GetSimMgr();

    private:
        static SimMgr          *Globl_SimMgr;
};


/**********************************************************
 * SimMgr_RegisterSim()
 **********************************************************/
int SimMgr_RegisterSim(SimInfo *simType);


#ifdef __cplusplus
};
#endif

#endif /* INCLUDED_Sim_MGR_H */
