/**************************************************************************** 
 *                            SdbrCursor.cc
 * Author: Matthew Ballance
 * Desc:   
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 ****************************************************************************/
#include "CursorMgr.h"
#include "SdbrCursor.h"
#include "SdbReader.h"
#include "SdbReader.h"
#include "SdbReader.h"
#include "SdbReader.h"
#include "CmdSwitcher.h"
#include <stdlib.h>

/******************************************************
 * SdbrCursor_InstCmd()
 ******************************************************/
static int SdbrCursor_InstCmd(ClientData clientData,
        Tcl_Interp *interp, int argc, char **argv)
{
    SdbrCursor *cursor = (SdbrCursor *)clientData;

    return cursor->InstCmd(argc, argv);
}

typedef enum {
    CUR_SetTime    = 1,
    CUR_GetTime,
    CUR_Selected,
    CUR_NextEdge,
    CUR_PrevEdge,
    CUR_Delete,
    CUR_Lock,
    CUR_LAST
} CursorCmds;

static CmdSwitchStruct cursorCmds[] = {
    {"set_time",         CUR_SetTime     },
    {"get_time",         CUR_GetTime     },
    {"selected",         CUR_Selected    },
    {"next_edge",        CUR_NextEdge    },
    {"prev_edge",        CUR_PrevEdge    },
    {"delete",           CUR_Delete      },
    {"lock",             CUR_Lock        },
    {"", 0}
};

/******************************************************
 * InstCmd
 ******************************************************/
int SdbrCursor::InstCmd(Uint32 argc, Char **argv)
{
    Uint32 cmd = CmdSwitch(cursorCmds, argv[1]);

    switch (cmd) {
        case CUR_SetTime:
            setTime(strtoul(argv[2], 0, 0));
            parent->update(); 
            break;

        case CUR_GetTime:
            Tcl_SetObjResult(interp, Tcl_NewIntObj(getTime()));
            break;

        case CUR_Selected:
            if (argc > 2) {
                select(strtoul(argv[2], 0, 0));
            } else {
                Tcl_SetObjResult(interp, Tcl_NewIntObj(isSelected()));
            }
            break;

        case CUR_PrevEdge:
        case CUR_NextEdge:
        {
            int           ret;
            Uint32        next;

            if (argc > 2) {
                ret = parent->sdbr->findEdge(argv[2], getTime(), 
                        (cmd == CUR_NextEdge)?1:0, &next);
                if (ret == TCL_OK) {
                    setTime(next);
                } 
            } else {
                Tcl_AppendResult(interp, "too few args", 0);
                return TCL_ERROR;
            }
        }
        break;

        case CUR_Delete:
        {
            delete this;
        }
        break;

        case CUR_Lock:
            if (argc == 2) {
                /**** Get value ****/
                Tcl_SetObjResult(interp, Tcl_NewIntObj(isLocked()));
            } else if (argc == 3) {
                Uint32 l = strtoul(argv[2], 0, 0);

                if (l != isLocked()) {
                    lock(l);
                    if (parent) {
                        parent->update();
                    }
                }
            }

            break;

        default:
            Tcl_AppendResult(interp, "Unknown Cursor command ", argv[1], 0);
            return TCL_ERROR;
        break;
    }

    return TCL_OK;
}

/******************************************************
 * select()
 ******************************************************/
void SdbrCursor::select(Uint32 sel) 
{
    if (sel != selected) {
        selected = sel;
        parent->update();
    }
}



/******************************************************
 * SdbrCursor
 ******************************************************/
SdbrCursor::SdbrCursor(Tcl_Interp *interp, CursorMgr *parent, Uint32 idx)
{

    instName = new Char[strlen(parent->getInstName())+32];
    sprintf(instName, "%s.cursor%d", parent->getInstName(), idx);

    this->idx    = idx;
    this->interp = interp;
    this->parent = parent;
    cursorTime = 0;
    locked = 0;
    selected = 0;

    Tcl_CreateCommand(interp, instName, 
            (Tcl_CmdProc *)SdbrCursor_InstCmd, this, NULL);
}

/******************************************************
 * ~SdbrCursor()
 ******************************************************/
SdbrCursor::~SdbrCursor(void)
{
    parent->delCursor(this);

    Tcl_DeleteCommand(interp, instName);
    delete [] instName;
}

/********************************************************************
 * setTime()
 ********************************************************************/
void SdbrCursor::setTime(Uint32 newTime)
{
    if (!locked) {
        cursorTime = newTime;
        if (parent) {
   	    parent->update();
        }
    }
}


/******************************************************
 * lock()
 ******************************************************/
void SdbrCursor::lock(Uint32 locked)
{
    this->locked = locked;
}



