/****************************************************************************
 *                                PsGC.cc
 *
 * Author: Matthew Ballance
 * Desc:   Placeholder to represent the GC for a Postscript pixmap
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "PsGC.h"
#include "GCObj.h"
#include "FileAccObj.h"

/********************************************************************
 * PsGC()
 ********************************************************************/
PsGC::PsGC(GCObj *gc_templ)
{
    d_gcObj = gc_templ;
    d_dpi   = 300;

    Tcl_DStringInit(&d_dStr);
}

/********************************************************************
 * SetGC()
 *
 * Configures this GC for use...
 ********************************************************************/
void PsGC::SetGC(FileAccObj *f)
{
    Double r, g, b;
    Uint32 foreground = d_gcObj->d_GCValues.foreground;

    r = ((foreground & 0xFF0000) >> 16);
    g = ((foreground & 0x00FF00) >> 8);
    b = ((foreground & 0x0000FF));

    r = r / 255.0;
    g = g / 255.0;
    b = b / 255.0;
    emit(f, "%f %f %f setrgbcolor stroke\n", r, g, b);

    if (d_gcObj->d_ValueMask & GCLineWidth) {
        emit(f, "%f setlinewidth stroke\n", 
                d_gcObj->d_GCValues.line_width / 2);
    } else {
        emit(f, "0.5 setlinewidth stroke\n");
    }

    if (d_gcObj->d_ValueMask & GCFont) {
        int size;
        Tcl_DStringSetLength(&d_dStr, 0);
        size = Tk_PostscriptFontName(d_gcObj->d_font, &d_dStr);

        emit(f, "/%s findfont %d scalefont setfont\n", 
                Tcl_DStringValue(&d_dStr), size);
    }
}

/********************************************************************
 * emit()
 ********************************************************************/
void PsGC::emit(FileAccObj *f, const char *fmt, ...)
{
    va_list   ap;
    va_start(ap, fmt);

    vsprintf(d_buf, fmt, ap);
    f->write_bytes((Uint8 *)d_buf, strlen(d_buf));
    va_end(ap);
}

char PsGC::d_buf[8192];

