/****************************************************************************
 *                           LogRegionType.h
 * 
 * Author: Matthew Ballance
 * Desc:   Implements the base logging region type... This type may be 
 *         extended...
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_LOG_REGION_TYPE_H 
#define INCLUDED_LOG_REGION_TYPE_H 
#include "ivi_String.h"

class LogMgr;
class LogRegionType {
    public:
        LogRegionType(
                const char        *typeName,
                const char        *shortDescStr,
                const char        *lowDbgDescStr,
                const char        *medDbgDescStr,
                const char        *highDbgDescStr);

        LogRegionType(const char *typeName);

        LogRegionType(LogRegionType *rType);

        inline void setLogMgr(LogMgr *mgr_p) { mgr = mgr_p; }
        inline LogMgr *getLogMgr() { return mgr; }

        inline String get_typeName() const { return regionTypeName; }

    private:
        LogMgr         *mgr;
        String          regionTypeName;
        String          shortDesc;
        String          longDesc;
        String          lowDbgDesc;
        String          medDbgDesc;
        String          highDbgDesc;
};

#endif /* INCLUDED_LOG_REGION_TYPE_H */
