/****************************************************************************
 *                         LogDestination.cc
 *
 * Author: Matthew Ballance
 * Desc:   Describes the destination for log output. This is just a base 
 *         class - other classes actually implement the _real_ destinations
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "LogDestination.h"
#include "LogInstance.h"

/********************************************************************
 * LogDestination()
 ********************************************************************/
LogDestination::LogDestination() : d_indent(256)
{
    instList = new Vector<LogInstance>();
    debugLevel = LogMgr::DebugLevel_Off;
    d_indent.setLen(0);
    d_indent[0] = 0;
}


/********************************************************************
 * write()
 ********************************************************************/
void LogDestination::write(char *msg)
{
    fprintf(stderr, "%s%s", d_indent.value(), msg);
}


/********************************************************************
 * setLogLevel()
 ********************************************************************/
void LogDestination::setLogLevel(LogMgr::DebugLevel lev)
{
    Uint32                i;
    LogInstance          *inst;
    LogMgr::DebugLevel    oldLev = debugLevel;

    debugLevel = lev;

    for (i=0; i<instList->length(); i++) {
        inst = instList->idx(i);
        inst->DestStateUpdate(this, oldLev);
    }
}

/********************************************************************
 * enter()
 *
 * This function just adds to the indent of this destination...
 ********************************************************************/
void LogDestination::enter()
{
    d_indent += "    ";
}

/********************************************************************
 * leave()
 ********************************************************************/
void LogDestination::leave()
{
    Uint32 len = d_indent.length();

    if (len >= 4) {
        d_indent.setLen(len-4);
        d_indent[d_indent.length()] = 0;
    } else {
        d_indent[0] = 0;
    }
}

/********************************************************************
 * addInstance()
 *
 ********************************************************************/
void LogDestination::addInstance(LogInstance *inst)
{
    instList->append(inst);
}
