/****************************************************************************
 *                         IviUintHashTabLevel.h
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_IVI_UINT_HASH_TAB_LEVEL_H
#define INCLUDED_IVI_UINT_HASH_TAB_LEVEL_H
#include "types.h"
#include <string.h>

class IviUintHashTabLevelBase {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * IviUintHashTabLevelBase()
         ************************************************************/
        IviUintHashTabLevelBase() { ; }

        /************************************************************
         * ~IviUintHashTabLevelBase()
         ************************************************************/
        virtual ~IviUintHashTabLevelBase() { ; }
};

class IviUintHashTabLevel : public IviUintHashTabLevelBase {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * IviUintHashTabLevel()
         ************************************************************/
        IviUintHashTabLevel(Uint32 depth) {
            d_children = new IviUintHashTabLevelBase *[16];
            memset(d_children, 0, sizeof(IviUintHashTabLevelBase *)*16);
            d_depth = depth;
        }

        /************************************************************
         * ~IviUintHashTabLevel()
         ************************************************************/
        virtual ~IviUintHashTabLevel() {
            delete [] d_children;
        }

        /************************************************************
         * getDepth()
         ************************************************************/
        Uint32 getDepth() { return d_depth; }

    /****************************************************************
     * Public Data
     ****************************************************************/
    public:
        IviUintHashTabLevelBase             **d_children;
        Uint32                                d_depth;
};

#endif /* INCLUDED_IVI_UINT_HASH_TAB_LEVEL_H */
