/****************************************************************************
 *                          IviRemoteCmdServer.cc
 *
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "IviRemoteCmdServer.h"
#include "IviRemoteAppIdx.h"
#include <string.h>


/********************************************************************
 * IviRemoteCmdServer()
 ********************************************************************/
IviRemoteCmdServer::IviRemoteCmdServer(Tcl_Interp *interp) :
    RemoteAppConnectionListener(IVI_CMD_CH_IDX_TCL_CMD)
{
    d_interp = interp;
}

/********************************************************************
 * ~IviRemoteCmdServer()
 ********************************************************************/
IviRemoteCmdServer::~IviRemoteCmdServer()
{
}

/********************************************************************
 * Receive() 
 ********************************************************************/
void IviRemoteCmdServer::Receive(Uint32 idx, Uint32 len, Uchar *data)
{
    int ret;

    fprintf(stderr, "IviRemoteCmdServer::Receive() - received command %s\n",
            data);

    ret = Tcl_EvalEx(d_interp, (char *)data, -1, TCL_EVAL_GLOBAL);

    /**** Now, send back the response and status... ****/
    d_respbuf[0] = ret;
    sprintf(&d_respbuf[1], Tcl_GetStringResult(d_interp));

    Send(IVI_CMD_CH_IDX_TCL_CMD_RESP, strlen(&d_respbuf[1])+2, 
            (Uchar *)d_respbuf);
}


char IviRemoteCmdServer::d_respbuf[16384];


