/****************************************************************************
 *                             FileAccObj.h
 *
 * Author: Matthew Ballance
 * Desc:   File-access class. Provides an abstract way of accessing files...
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_FILE_ACC_OBJ_H
#define INCLUDED_FILE_ACC_OBJ_H
#include <stdio.h>
#include "types.h"
#include "ivi_String.h"
#include <stdarg.h>

#define  FILE_ACC_OPEN_READ         0x00000001
#define  FILE_ACC_OPEN_WRITE        0x00000002

class FileAccObj {
    public:
        enum FileOpenMode {
            OpenMode_Read   = 0x0001,
            OpenMode_Write  = 0x0002
        };

        FileAccObj();
        FileAccObj(const char *filename, enum FileOpenMode openFlags);
        ~FileAccObj();

        virtual void operator () (const char *filename, 
                enum FileOpenMode openFlags);

        virtual void operator = (FileAccObj &rhs);


        inline const char *get_filename() { return fileName.value(); }
        inline Uint32 get_bigEndian() { return bigEndian; }
        inline void set_bigEndian(Uint32 val) { bigEndian = val; }

        inline char *get_error() { return errString.value(); }

        /************************************************************
         * print()
         ************************************************************/
        virtual void print(const char *fmt, ...);

        /************************************************************
         * write_bytes()
         *
         * Writes 'len' bytes to this file. Returns '0' on success
         * or '-1' on error.
         ************************************************************/
        virtual int write_bytes(Uint8 *buf, Uint32 len);

        /************************************************************
         * read_bytes()
         *
         * Reads 'len' bytes into the specified buffer.
         ************************************************************/
        virtual int read_bytes(Uint8 *buf, Uint32 len);

        /************************************************************
         * write_uint32()
         *
         * Writes a 32-bit integer to the file. The endian 
         * representation of the integer is determined by bigEndian
         ************************************************************/
        virtual int write_uint32(Uint32 val);

        /************************************************************
         * read_uint32()
         ************************************************************/
        virtual int read_uint32(Uint32 *val_ptr);

        /************************************************************
         * write_uint8()
         ************************************************************/
        virtual int write_uint8(Uint8 val);

        /************************************************************
         * read_uint8()
         ************************************************************/
        virtual int read_uint8(Uint8 *val);

        /************************************************************
         * close()
         ************************************************************/
        virtual int close();

        /************************************************************
         * eof()
         ************************************************************/
        virtual int eof();

        /**** Check this member after construction ****/
        Uint32        okay;

    private:
        String        fileName;
        String        errString;
        FILE         *fp;
        Uint32        bigEndian;
        Uint32        currPos;
        Uint32        openMode;
        Uint32        ownFp;
        static char   d_buf[8192];
};

#endif /* INCLUDED_FILE_ACC_OBJ_H */


