/*****************************************************************************
 *                              CmdSwitcher.h
 * Author: Matthew Ballance
 * Desc:   
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *****************************************************************************/
#ifndef INCLUDED_CMD_SWITCHER_H
#define INCLUDED_CMD_SWITCHER_H
#include "types.h"

typedef struct {
    Char        *cmdString;
    Int32        cmdIdx;
 } CmdSwitchStruct;

/**************************************************************
 * CmdSwitch()
 **************************************************************/
Int32 CmdSwitch(CmdSwitchStruct    *Cmds, Char *Cmd);

typedef struct {
    Char        *optString;
    Int32        optType;
    boolean      flagOpt;    /*** true  if option is -flag
                              *** false if option is -opt val
                              ***/
} OptTypeStruct;

/**************************************************************
 * ParseArgs()
 **************************************************************/
Int32 ParseArgs(
    OptTypeStruct   *optSpec,
    Uint32           argc,
    Char           **argv,
    Uint32          *argcO, 
    Char           **argvO,
    Uint32          *optcO,
    Char           **optO,
    Int32           *optTO
    );

/**************************************************************
 * CmdSwitch_AppendAll()
 **************************************************************/
void CmdSwitch_AppendAll(struct Tcl_Interp *interp, CmdSwitchStruct *cmds);


#endif /*INCLUDED_CMD_SWITCHER_H*/
