/****************************************************************************
 *                           CallbackTypes.h
 *
 * Author: Matthew Ballance
 * Desc:   Defines the core callback types for the IVI system
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_CALLBACK_TYPES_H
#define INCLUDED_CALLBACK_TYPES_H

/********************************************************************
 * CBTYPE_SDBR_SIGLIST_UPDATE
 * Registered on a particular SDBR instance. Called whenever the
 * SDBR's signal-list changes
 * - new signals added
 * - positional changes in the signal list
 * - changes in display format (radix, expanded/non-expanded, etc)
 ********************************************************************/
#define CBTYPE_SDBR_SIGLIST_UPDATE "SDBR.SigListUpdate"

/********************************************************************
 * CBTYPE_SDBR_SIGDATA_UPDATE
 *
 * Called at certain intervals when the data present on SDBR signals
 * changes. During simulation, this callback will be invoked at the
 * end of time-steps. Clients of SDBRs should redraw when a callback
 * of this type is received.
 ********************************************************************/
#define CBTYPE_SDBR_SIGDATA_UPDATE "SDBR.SigDataUpdate"

/********************************************************************
 * CBTYPE_SDB_SIGDATA_UPDATE
 ********************************************************************/
#define CBTYPE_SDB_SIGDATA_UPDATE "SDB.SigDataUpdate"

/********************************************************************
 * CBTYPE_SIM_RUNSTEP_START
 *
 * Called before a run/step begins
 ********************************************************************/
#define CBTYPE_SIM_RUNSTEP_START "Sim.RunStepStart"

/********************************************************************
 * CBTYPE_SIM_RUNSTEP_UPDATE
 *
 * Called during the run to refresh the GUI
 ********************************************************************/
#define CBTYPE_SIM_RUNSTEP_UPDATE "Sim.RunStepUpdate"

/********************************************************************
 * CBTYPE_SIM_RUNSTEP_END
 *
 * Called at the end of a run/step
 ********************************************************************/
#define CBTYPE_SIM_RUNSTEP_END "Sim.RunStepEnd"

/********************************************************************
 * CBTYPE_SIM_DESIGN_LOAD
 *
 * Called when the Sim object loads a new design
 ********************************************************************/
#define CBTYPE_SIM_DESIGN_LOAD  "Sim.DesignLoad"

/********************************************************************
 * CBTYPE_SIM_DESIGN_CLOSE
 *
 * Called when the Sim object loads a new design
 ********************************************************************/
#define CBTYPE_SIM_DESIGN_CLOSE  "Sim.DesignClose"

/********************************************************************
 * CBTYPE_SDB_MGR_UPDATE
 ********************************************************************/
#define CBTYPE_SDB_MGR_UPDATE "SDB.MgrUpdate"

/********************************************************************
 * CBTYPE_DDB_UPDATE
 ********************************************************************/
#define CBTYPE_DDB_UPDATE "DDB.Update"

/********************************************************************
 * CBTYPE_X_BUTTON_PRESS
 ********************************************************************/
#define CBTYPE_X_BUTTON_PRESS "X.ButtonPress"

/********************************************************************
 * CBTYPE_X_BUTTON_RELEASE
 ********************************************************************/
#define CBTYPE_X_BUTTON_RELEASE "X.ButtonRelease"

/********************************************************************
 * CBTYPE_X_BUTTON_DOUBLE_PRESS
 ********************************************************************/
#define CBTYPE_X_BUTTON_DOUBLE_PRESS "X.ButtonDoublePress"

/********************************************************************
 * CBTYPE_X_MOTION
 *
 * Args:
 * - x
 * - y
 ********************************************************************/
#define CBTYPE_X_MOTION "X.MotionNotify"

/********************************************************************
 * CBTYPE_STIM_SEQ_LST_UPDATE
 ********************************************************************/
#define CBTYPE_STIM_SEQ_LST_UPDATE "StimMgr.StimSeqListUpdate"

/********************************************************************
 * CBTYPE_WAVEW_WINDOW_CHANGE
 *
 * Args:
 * - time_start   (integer)
 * - time_end     (integer)
 * - pix_per_time (double)
 ********************************************************************/
#define CBTYPE_WAVE_WINDOW_CHANGE "WaveWin.WindowChange"

/********************************************************************
 * CBTYPE_CURSOR_LIST_UPDATE
 ********************************************************************/
#define CBTYPE_CURSOR_LIST_UPDATE "CursorMgr.CursorListUpdate"

/********************************************************************
 * CBTYPE_CURSOR_POS_CHANGE
 *
 * Callback is triggered when a cursor changes position.
 ********************************************************************/
#define CBTYPE_CURSOR_POS_CHANGE "CursorMgr.CursorPosChange"

#endif /* INCLUDED_CALLBACK_TYPES_H */

