/****************************************************************************
 *                          BitVectorABVal.h
 *
 * Author: Matthew Ballance
 * Desc:
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_BIT_VECTOR_AB_VAL_H
#define INCLUDED_BIT_VECTOR_AB_VAL_H
#include "DFIOValChg.h"
#include "ivi_String.h"

class BitVectorABVal {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * BitVectorABVal()
         ************************************************************/
        BitVectorABVal(
                const DFIOVal8       *val,
                Uint32                bitLen);

        /************************************************************
         * BitVectorABVal()
         ************************************************************/
        BitVectorABVal(
                const DFIOVal32      *val,
                Uint32                bitLen);

        /************************************************************
         * BitVectorABVal()
         ************************************************************/
        BitVectorABVal(const BitVectorABVal &src);

        /************************************************************
         * BitVectorABVal()
         ************************************************************/
        BitVectorABVal(
                const String         &value,
                Uint32                flags);

        /************************************************************
         * fmtBin()
         ************************************************************/
        static void fmtBin(
                const DFIOVal        *in,
                Uint32                in_len,
                String               &out,
                Uint32                flags,
                Uint32               &infoFlags);

        /************************************************************
         * fmtHex()
         ************************************************************/
        static void fmtHex(
                const DFIOVal        *in,
                Uint32                in_len,
                String               &out,
                Uint32                flags,
                Uint32               &infoFlags);

        /************************************************************
         * fmtOct()
         ************************************************************/
        static void fmtOct(
                const DFIOVal        *in,
                Uint32                in_len,
                String               &out,
                Uint32                flags,
                Uint32               &infoFlags);

        /************************************************************
         * fmtDec()
         ************************************************************/
        static void fmtDec(
                const DFIOVal        *in,
                Uint32                in_len,
                String               &out,
                Uint32                flags,
                Uint32               &infoFlags);

        /************************************************************
         * fmtString()
         ************************************************************/
        static void fmtString(
                const DFIOVal        *in,
                Uint32                in_len,
                String               &out,
                Uint32                flags,
                Uint32               &infoFlags);

        /************************************************************
         * setSize()
         *
         * Sets the size of the bitvector without changing any data
         * This routine is used to ensure that the bitvector is 
         * large enough.
         ************************************************************/
        void setSize(Uint32 bitLen);

        /************************************************************
         * operator = (BitVectorABVal)
         ************************************************************/
        void operator = (const BitVectorABVal &rhs);

        /************************************************************
         * operator = (Uint32)
         ************************************************************/
        void operator = (Uint32);

        /************************************************************
         * add()
         ************************************************************/
        static void add(
                BitVectorABVal             &dest,
                const BitVectorABVal       &op1,
                const BitVectorABVal       &op2);

        /************************************************************
         * operator +
         ************************************************************/
        const BitVectorABVal operator + (const BitVectorABVal &rhs);

        /************************************************************
         * RadixFlags
         ************************************************************/
        enum RadixFlags {
            RadixFlags_Bin     = 0x001,
            RadixFlags_Hex     = 0x002,
            RadixFlags_Dec     = 0x003,
            RadixFlags_Oct     = 0x004,
            RadixFlags_Str     = 0x005,
            RadixFlags_Signed  = 0x100,
            RadixFlags_Sized   = 0x200,
            RadixFlags_Typed   = 0x400
        };

        enum FmtInfoFlags {
            FmtInfo_HasXZ   = 0x0001,
            FmtInfo_ExclZ   = 0x0002,
            FmtInfo_ExclX   = 0x0004,
            FmtInfo_NumFlag
        };

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * setFmtInfoFlags()
         ************************************************************/
        static void setFmtInfoFlags(Uint32 &flags, Uint32 n0, Uint32 n1, 
                Uint32 nz, Uint32 nx);

        /************************************************************
         * fmtAddAttributes()
         ************************************************************/
        static void fmtAddAttributes(
                char                  radixChar,
                Uint32                in_len,
                String               &out,
                Uint32               &idx,
                Uint32                flags);

        /************************************************************
         * fmtOct_WriteDigits()
         ************************************************************/
        static void fmtOct_WriteDigits(
                Uint32                value,
                Uint32                numDigits,
                String               &out,
                Uint32               &idx);

        /************************************************************
         * divTen()
         ************************************************************/
        static void divTen(
                Uint8                  *in,
                Uint32                 &v_len,
                Uint32                 &remainder);

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        DFIOVal8                   *d_value;
        Uint32                      d_valueLen;
        Uint32                      d_valueMaxLen;

        Uint32                      d_bitLen;

        static Uint8               *d_fmtDecTmp;
        static Uint32               d_fmtDecTmpLen;
};

#endif /* INCLUDED_BIT_VECTOR_AB_VAL_H */
