--------------------------------------------------------------------------------
-- Project:     fb-unisim: simplified behavioral version of Xilinx Unisim library
-- File:        fb-unisim_VCOMP.vhd
-- Description: equivalent to unisim_VCOMPL.vhd, virtual components
-- History:     2003vi24, FB, created.
--------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;

package vcomponents is
--------------------------------------------------------------------------------
	----- Component BUFG -----
	component BUFG 
		port(
			O :	out   STD_ULOGIC;
			I :	in    STD_ULOGIC);
	end component;

--------------------------------------------------------------------------------
	----- Component SRL16E -----
	component SRL16E 
		generic (
			INIT : bit_vector := X"0000");
		port (
			D   : in STD_ULOGIC;
			CE  : in STD_ULOGIC;
			CLK : in STD_ULOGIC;
			A0  : in STD_ULOGIC;
			A1  : in STD_ULOGIC;
			A2  : in STD_ULOGIC;
			A3  : in STD_ULOGIC;
			Q   : out STD_ULOGIC); 
	end component;
	
--------------------------------------------------------------------------------
	----- Component RAMB4_S16_S16 -----
	component RAMB4_S16_S16 
		generic (
			INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
			INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000");
		port (
			DIA    : in STD_LOGIC_VECTOR (15 downto 0);
			DIB    : in STD_LOGIC_VECTOR (15 downto 0);
			ENA    : in STD_ULOGIC;
			ENB    : in STD_ULOGIC;
			WEA    : in STD_ULOGIC;
			WEB    : in STD_ULOGIC;
			RSTA   : in STD_ULOGIC;
			RSTB   : in STD_ULOGIC;
			CLKA   : in STD_ULOGIC;
			CLKB   : in STD_ULOGIC;
			ADDRA  : in STD_LOGIC_VECTOR (7 downto 0);
			ADDRB  : in STD_LOGIC_VECTOR (7 downto 0);
			DOA    : out STD_LOGIC_VECTOR (15 downto 0);
			DOB    : out STD_LOGIC_VECTOR (15 downto 0)); 
	end component;

--------------------------------------------------------------------------------
----- Component CLKDLL -----
	component CLKDLL
		generic ( 
			FACTORY_JF : bit_vector := X"00";
			STARTUP_WAIT : boolean := false;
			DUTY_CYCLE_CORRECTION : Boolean := TRUE;
			CLKDV_DIVIDE : real := 2.0);
		port (
			CLKIN   : in  std_ulogic := '0';
			CLKFB   : in  std_ulogic := '0';
			RST     : in  std_ulogic := '0';
			CLK0    : out std_ulogic := '0';
			CLK90   : out std_ulogic := '0';
			CLK180  : out std_ulogic := '0';
			CLK270  : out std_ulogic := '0';
			CLK2X   : out std_ulogic := '0';
			CLKDV   : out std_ulogic := '0';
			LOCKED  : out std_ulogic := '0');
	end component;
	
--------------------------------------------------------------------------------
----- Component FDC -----
	component FDC
	   generic(
		  INIT :          bit := '0');
	   port(   
		  Q    :	out   STD_ULOGIC;
		  D    :	in    STD_ULOGIC;
		  C    :	in    STD_ULOGIC;
		  CLR  :	in    STD_ULOGIC);
	end component;

--------------------------------------------------------------------------------
----- Component FDR -----
component FDR
   generic(
      INIT                           :  bit := '0'  );
   port(
      Q                              :	out   STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC);
end component;
	
--------------------------------------------------------------------------------
----- Component FDRE -----
component FDRE
   generic(
      INIT                           :  bit := '0'  );
   port(
      Q                              :	out   STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      CE                             :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC);
end component;

--------------------------------------------------------------------------------
----- Component SRL16 -----
	component SRL16
	  generic (
		   INIT :     bit_vector := X"0000");
	  port (D   : in  STD_ULOGIC;
			CLK : in  STD_ULOGIC;
			A0  : in  STD_ULOGIC;
			A1  : in  STD_ULOGIC;
			A2  : in  STD_ULOGIC;
			A3  : in  STD_ULOGIC;
			Q   : out STD_ULOGIC); 
	end component;

--------------------------------------------------------------------------------
----- Component RAM16X1D -----
	component RAM16X1D
	  generic (
		   INIT   :     bit_vector := X"0000");
	  port (D     : in  std_ulogic;
			WE    : in  std_ulogic;
			WCLK  : in  std_ulogic;
			A0    : in  std_ulogic;
			A1    : in  std_ulogic;
			A2    : in  std_ulogic;
			A3    : in  std_ulogic;
			DPRA0 : in  std_ulogic;
			DPRA1 : in  std_ulogic;
			DPRA2 : in  std_ulogic;
			DPRA3 : in  std_ulogic;
			SPO   : out std_ulogic;
			DPO   : out std_ulogic);
	end component;

end package;

--------------------------------------------------------------------------------
-- end of file
