//------------------------------------------------------------------------------
// Project:     vendor_lib: IVI example showing use of vendor-specific libs
// File:        vendor_lib.v
// Description: main module
// History:     2003iv17, FB, created.
//------------------------------------------------------------------------------

`timescale 1us / 1ns

module vendor_lib ();
	reg  tbC;   // clock
	reg  tbCE;  // clock enable
	reg  tbCLR; // async clear
	reg  tbD;   // data input
	wire tbQ;   // data output
	
	initial begin
		$display("\n\nvendor_lib\n\n");
		#30 $finish;
	end
		
	always #1 tbC = ~tbC;

	initial begin
		tbC=  0;
		tbCE= 0;
		
		// CLR = 1
		#2 tbCLR= 1;
		#2 tbCLR= 0;
		
		// CE = 0
		#2 tbCE = 0;
		#2 tbD  = 0;
		#2 tbD  = 1;
		
		// CE = 1
		#2 tbCE = 1;
		#2 tbD  = 0;
		#2 tbD  = 1;
		
		// CLR = 1
		#2 tbCLR= 1;
		#2 tbCLR= 0;
	end
	
	myFDCE UUT(
		.Q    (tbQ),
		.C    (tbC),
		.CE   (tbCE),
		.CLR  (tbCLR),
		.D    (tbD));
		
endmodule

//------------------------------------------------------------------------------
// end of file
