/****************************************************************************
 *                              alu_tb_vlog.v
 * 
 * Author: Matthew Ballance
 * Desc:   Implements a simple testbench for the ALU. The stimulus from 
 *         this testbench may be applied to the ALU through the stub tb.
 ****************************************************************************/
`include "alu_ops.v"
module alu_tb_vlog;

reg           clk, valid;
reg  [31:0]   in_a, in_b;
reg  [7:0]    op;

wire [31:0]   out;

alu alu_1(clk, valid, in_a, in_b, out, op);

/**** Create a clock ****/
initial clk = 0;
always #100 clk = ~clk;

task do_cycle;
    input  [31:0] in_a_p, in_b_p; 
    input  [7:0]  op_p;
    output [31:0] res;
    begin
        in_a = in_a_p;
        in_b = in_b_p;
        op   = op_p;

        valid = 0;
        #100 valid = 1;
        #200 valid = 0;

        #1000 ;

        res = out;
    end
endtask

reg [31:0]    i, res;
initial
begin
    op = `OP_MUL;
    for (i=0; i<10; i=i+1)
    begin
        do_cycle(i, 10-i, `OP_MUL, res);
        $display("Result of %d => %d", i, res);
    end
end

endmodule
