
# Expect:
# - MODULE_NAME
# - MODULE_LIB
#   tcl_sources

# tcl_files := $(foreach file,$(tcl_sources),ivi_$(file))
tcl_files := $(tcl_sources)

PKG_IDX_FLAGS = -pkg $(MODULE_NAME)

ifeq ("$(ENABLE_SHARED_BUILD)","no")
    echo "ENABLE_SHARED_BUILD = $(ENABLE_SHARED_BUILD)"
    MODULE_LIB=lib$(MODULE_NAME).a
else
    echo "ENABLE_SHARED_BUILD = $(ENABLE_SHARED_BUILD)"
    MODULE_LIB=lib$(MODULE_NAME).$(SLIB_EXT)
endif

ifeq ("$(MODULE_OBJ)","")
    MODULE_LIB=
endif

ifeq ("$(MODULE_DIR)","")
    MODULE_DIR=$(MODULE_NAME)
endif

pkgIndex.tcl : $(MODULE_LIB) $(foreach file,$(tcl_files),$(srcdir)/$(file))

.PHONY: clean module-install

INSTALL_TARGETS=module-install

ifeq ("$(ENABLE_SHARED_BUILD)", "no")
    BUILT_INSTALL_FILES = $(MODULE_BUILT_DATA) $(tcl_files) pkgIndex.tcl
else
    BUILT_INSTALL_FILES = $(MODULE_LIB) $(MODULE_BUILT_DATA) $(tcl_files) pkgIndex.tcl
endif

module-install: \
        $(foreach file,$(BUILT_INSTALL_FILES), $(prefix)/modules/$(MODULE_NAME)/$(file)) \
        $(foreach file,$(MODULE_DATA), $(prefix)/modules/$(MODULE_NAME)/$(file))

#	@tfl='$(BUILT_INSTALL_FILES)'; for f in $$tfl; do \
#            echo "Install $$f" ; \
#            $(INSTALL_DATA) "$$f" $(prefix)/modules/$(MODULE_NAME)/"$$f" || \
#	        $(DIE) ; \
#         done; 
#	@tfl='$(MODULE_DATA)'; for f in $$tfl; do \
#            echo "Install $$f" ; \
#            $(INSTALL_DATA) $(srcdir)/"$$f"  \
#	        $(prefix)/modules/$(MODULE_NAME)/"$$f" || $(DIE) ; \
#         done;

$(prefix)/modules/$(MODULE_NAME)/% : $(blddir)/%
	$(INSTALL_DATA) $(blddir)/$* $(prefix)/modules/$(MODULE_NAME)/$* \
             || $(DIE)

$(prefix)/modules/$(MODULE_NAME)/% : $(srcdir)/%
	$(INSTALL_DATA) $(srcdir)/$* $(prefix)/modules/$(MODULE_NAME)/$* \
             || $(DIE)

$(prefix)/modules/$(MODULE_NAME)/% : ./%
	$(INSTALL_DATA) ./$* $(prefix)/modules/$(MODULE_NAME)/$* \
             || $(DIE)

local-clean : 
	rm -f *.o *~ *.$(SLIB_EXT) *.a *.vpi pkgIndex.tcl $(MODULE_CLEAN)

CFLAGS := -UUSE_TCL_STUBS -UUSE_TK_STUBS $(CFLAGS)
CXXFLAGS := -UUSE_TCL_STUBS -UUSE_TK_STUBS $(CXXFLAGS)

ifeq ($(ENABLE_SHARED_BUILD), no) 
    PKG_IDX_FLAGS := -static $(PKG_IDX_FLAGS)
endif

ifeq ("$(MODULE_LIB)","")
else
ifeq ("$(ENABLE_SHARED_BUILD)", "no")
    $(MODULE_LIB) : $(MODULE_OBJ)
	$(AR_CMD) || $(DIE)
else
    $(MODULE_LIB) : $(MODULE_OBJ)
	$(SLIB_CMD) $(MODULE_LIBS) || $(DIE)
endif
endif


