<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("admin");

commonHeader(_("Setup") . " - " . _("FastTrack Templates"));

__("Please select a FastTrack template below to edit or delete.");
PRINT "<br />";
printf('<a href="%s">%s</a>', Config::AbsLoc('users/setup-fasttrack-add-form.php'),
		("Add a new FastTrack template"));
PRINT "<br />";

$query = "SELECT * FROM fasttracktemplates";
$DB = Config::Database();
$data = $DB->getAll($query);

PRINT "<table border=1 width=100%>";
PRINT "<TR><TH colspan=2>";
__("FastTrack Templates");
PRINT "</TH></TR>";
foreach ($data as $result)
{
  	$ID = $result["ID"];
  	$name = $result["name"];
  	PRINT '<tr BGCOLOR=#DDDDDD><td><a href="'.Config::AbsLoc("users/setup-fasttrack-edit.php?ID=$ID")."\">$name</a></td>
		<td><a href=\"".Config::AbsLoc("users/setup-fasttrack-del.php?ID=$ID")."\">";
		__("[Delete]");
		PRINT "</a> </td></tr><br>";
}
PRINT "</table>";
commonFooter();
