<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../../include/irm.inc");
include("../../include/reports.inc.php");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("normal");
PRINT "<html><body bgcolor=#ffffff>";
if ($go == "yes") 
{
	commonHeader(_("Reports") . " - " . _("Default Report"));
	# 1. Get some number data

	$query = "SELECT ID FROM computers";

	$DB = Config::Database();

	$computers = $DB->getCol($query);
	$number_of_computers = count($computers);

	$query = "SELECT ID FROM software";

	$software = $DB->getCol($query);
  	$number_of_software = count($software);
	
	# 2. Spew out the data in a table
	
	PRINT "<table border=0 width=100%>";
	PRINT "<tr><td>";
	__("Number of Computers:");
	PRINT "</td><td>$number_of_computers</td></tr>";	
	PRINT "<tr><td>";
	__("Amount of Software:");
	PRINT "</td><td>$number_of_software</td></tr>";

	PRINT "<tr><td colspan=2><b>";
	__("Operating Systems");
	PRINT ":</b></td></tr>";

	# 3. Get some more number data (operating systems per computer)

	$query = "SELECT * FROM dropdown_os ORDER BY name";
	$oslist = $DB->getAll($query);
	
	foreach ($oslist as $result)
	{
		$os = $DB->getTextValue($result["name"]);
		$query = "SELECT COUNT(ID) FROM computers WHERE (os = $os)";

		$oscount = $DB->getOne($query);
		PRINT "<tr><td>$os</td><td>$oscount</td></tr>";
	}
	PRINT "</table>";
}
else 
{
	commonHeader(_("Reports") . " - " . _("Default Report"));
	__("Welcome to the Default Report!  This report is designed to be a
	    functional model of a real IRM Report.  It provides some simple
	    data, but could really be extended with graphics, percentages,
	    graphs, and user settable options.  But it serves as a good
	    jumping point for making your own report. (NOTE: The IRM header
	    is not necessary, I just put it in.  You must do a 'connectDB();'
	    though.)");
	echo '<p>'._("To generate the report, click on this button:");
?>
 
	<form action="<?php echo Config::AbsLoc('users/reports/default.php'); ?>">
	  <input type=submit value=Go>
	  <input type=hidden name=go value=yes>
	</form>
<?php
}
PRINT "</body></html>";
?>
