<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("tech");

commonHeader(_("Knowledge Base") . " - " . _("Modify Article"));

$query = "select * from kbarticles where (ID = $ID)";
$DB = Config::Database();
$result = $DB->getRow($query);
$answer = $result["answer"];
$question = $result["question"];
$faq = $result["faq"];
$categorylist = $result["categoryID"];


__("Here is where you can modify an article that is in the knowledge base.") ?>
<hr noshade>
<BR>
<form method=post action="<?php echo Config::AbsLoc('users/knowledgebase-article-preview.php') ?>">
<?php 
__("Select the category in which this article should be placed:");
kbcategoryList($categorylist);
 ?>
<br>
<br>

<?php __("Modify the question here.  Please be as detailed as possible with the question, but don't repeat information that can be inferred by the category.") ?>

<textarea cols=50 rows=14 wrap=soft name=question><?php echo $question ?></textarea>
<br>

<?php __("Modify the answer here.  Please be as detailed as possible with the answer, including a step by step process."); ?>

<textarea cols=50 rows=14 wrap=soft name=answer><?php echo $answer ?></textarea>
<br>
<input type=checkbox name=faq value="yes" <?php echo ($faq == 'yes' ? 'checked' : '') ?>>
<?php __("Place this Knowledge Base Article into the publicly viewable FAQ as well.") ?>
<BR>
<input type=hidden name=modify value=1>
<input type=hidden name=ID value=<?php echo $ID ?>>
<input type=submit value="Preview Article">
<input type=reset value="Reset">
</form>

<?php
commonFooter();
