<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999,2000 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("post-only");
$user = new User($IRMName);
$type = $user->getType();
if ($type == "post-only")
{
 	header("Location: ".Config::AbsLoc("users/helper.php"));
 	__("Redirecting to users/helper.php"); ## does this even need to be here?
 	exit();
}
commonHeader(_("Command Center"));
if($type == "admin" || $type == "tech")
{
	__("Welcome to IRM, the Information Resource Manager!  This is the
	command center.  The command center is designed to allow a quick
	look at all work requests assigned to you, as well as an overview
	of recent changes IRM.  You can navigate to any of the sub modules
	of IRM by choosing the appropiate entry on the toolbar above.");
        echo "<p>\n";
        echo "<table border=1 width=100%>\n";
	echo "<tr><th>";
	__("Last 5 Events");
	echo "</th></tr>\n";
	echo "<tr><td>\n";

	$query = "SELECT * FROM event_log ORDER BY date DESC LIMIT 0,5";
	show_events($DB->getAll($query));
	
	$DB = Config::Database();
	
	$uname = $DB->getTextValue($IRMName);
	$query = "SELECT advanced_tracking,tracking_order FROM prefs WHERE (user = $uname)";
	$result = $DB->getRow($query);
  	$advanced_tracking = $result["advanced_tracking"];
  	$tracking_order = $result["tracking_order"];
	
	if($tracking_order == "yes")
	{
		$tracking_order = "date ASC";
	}
	else
	{
		$tracking_order = "date DESC";
	}
	
	PRINT "</td></tr>\n";
	PRINT "<tr><th>";
	__("Tracking");
	PRINT "</th></tr>\n";
	PRINT "<tr><td>\n";
	#
	# Show how many jobs you have assigned to you currently :)
	#
	$notClosed = Tracking::getNotClosed("yes", "individual", $tracking_order);
	$notClosedSize = sizeof($notClosed);
	
	printf('<a href="%s">%s</a>',
				Config::AbsLoc("users/tracking-index.php?show=individual"),
				sprintf(_("You have %s job(s) assigned to you."), $notClosedSize)
				);
	if (Config::Get('showjobsonlogin'))
	{
		Tracking::displayHeader(false);
		for($i=0;$i<$notClosedSize;$i++)
		{
			$track = new Tracking($notClosed[$i]);
			$track->display(1);
		}
		Tracking::displayFooter();
	}
	
	PRINT "</td></tr></table>\n";
}
if($type != "admin" && $type != "tech" && $type == "normal")
{

	__("Welcome to IRM, the Information Resource Manager!  This is the
	command center.  The command center is designed to allow a quick
	look at all work requests assigned to you, as well as an overview
	of recent changes IRM.  You can navigate to any of the sub modules
	of IRM by choosing the appropiate entry on the toolbar above.");

}
if ($type == "normal" || $type == "tech" || $type == "admin")
{
	PRINT "<table border=1 width=100%>\n";
	PRINT "<tr><th>";
	__("Open Work Requests");
	PRINT "</th></tr>\n";
	PRINT "<tr><td>\n";
	$notClosed = Tracking::getNotClosedBy("ASC");
	$notClosedSize = sizeof($notClosed);
		
	printf(_("You have entered %s request(s) that have not yet been completed."),
			$notClosedSize);

	if (Config::Get('showjobsonlogin'))
	{
		Tracking::displayHeader(false);
		for($i=0;$i<$notClosedSize;$i++)
		{
			$track = new Tracking($notClosed[$i]);
			$track->display(1);
		}
		Tracking::displayFooter();
	}
	
	PRINT "</td></tr></table>\n";
}
commonFooter();
