<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("post-only");
$user = new User($IRMName);
$type = $user->getType();
$IRMemail = $user->getEmail();

if($type != "post-only")
{
	$uname = $IRMName;
	$fname = $user->getFullname();
	$uemail = $IRMemail;
}

$DB = Config::Database();

if($is_group == "yes")
{
	$query = "select ID from groups where (name = \"$groupname\")";
	$ID = $DB->getOne($query);
}

$qID = $DB->getTextValue($ID);
if($is_group == "no")
{
	$query = "SELECT COUNT(name) FROM computers WHERE (ID = $qID)";
}
else
{
 	$query = "SELECT COUNT(name) FROM groups WHERE (ID = $qID)";
}

if (!$DB->getOne($query)) 
{
	commonHeader(_("Tracking") . " - " . _("Bad ID Number"));
	__("It appears that you have entered an incorrect IRM computer ID or group ID number.");
	PRINT '<a href="' . Config::AbsLoc('users/helper.php') . '">';
	__("Please try again.");
	PRINT "</a><br>";

	commonFooter();
	exit();
}

commonHeader(_("Tracking") . " - " . _("Add Job"));

__("You can use this form to submit a problem report or request help with a computing resource in your organization.  Please fill out the entire form as clearly as possible.");
PRINT "<hr noshade>";

$qID = $DB->getTextValue($ID);
if (strtolower($is_group) == 'yes')
{
	$group = " AND is_group='yes'";
}
else
{
	$group = " AND is_group='no'";
}
$sql = "SELECT ID, LEFT(contents, 120) as contents FROM tracking WHERE computer=$qID AND status <> 'complete' $group";
$data = $DB->getAll($sql);
if (count($data) > 0)
{
	// there are currently open trackings on this IRM...
	__("There are currently open trackings on this device. Please take a moment to scan the list to make sure you are not duplicating an already open work request. If you'd like to make additional comments on an open tracking, please click the ID link and add a followup to that tracking.\n");
	PRINT "<p><table>\n";
	PRINT "<tr BGCOLOR=#DDDDDD><th>ID</th><th>";
	__("Problem Reported");
	PRINT "</th></tr>\n";
	foreach ($data as $result)
	{
		$id = $result['ID'];
		PRINT "<TR BGCOLOR=#EEEEEE><td>";
		PRINT '<a href="'.Config::AbsLoc("users/tracking-followups.php?ID=$id") . "\">$id</a>";
		PRINT "</td><td>" . $result["contents"];
		if (strlen($result["contents"]) >= 120)
		{
			PRINT "...";
		}
		PRINT "</td></tr>\n";
        }
	PRINT "</table><p>";
	__("If none of the above trackings matched your current issue, please continue by submitting your request below.");
	PRINT "<hr noshade>\n";
}

PRINT '<form method=post action="'.Config::AbsLoc('users/helper-preview.php').'">';
?>
<br>
<input type="hidden" name="status" value="new">

<br><br><strong><?php __("The Computer or Group you are requesting work on:"); ?></strong> <br>
<?php
$qID = $DB->getTextValue($ID);
if($is_group == "no")
{
	$query = "SELECT name FROM computers WHERE (ID = $qID)";
}
else
{
	$query = "SELECT name FROM groups WHERE (ID = $qID)";
}
$computername = $DB->getOne($query);

PRINT "$computername ($ID) <br>"; 
PRINT "<input type=hidden name=ID value=\"$ID\">";
PRINT "<input type=hidden name=is_group value=\"$is_group\">";
PRINT "<br>";

__("First, pick how urgent your request is.  If it can wait, pick a low priority.  If you are stuck, pick a high priority.  If you are unsure how important the problem is, leaving it at its present value should be OK."); ?>
<br><br>
<strong><?php __("Priority:"); ?></strong><br><select name=priority>
<option value=5><?php __("Very High"); ?></option>
<option value=4><?php __("High"); ?></option>
<option value=3 selected><?php __("Normal"); ?></option>
<option value=2><?php __("Low"); ?></option>
<option value=1><?php __("Very Low"); ?></option>
</select>
<br>
<br>
<?php __("If you are entering this tracking item on behalf of another user, please provide their name and e-mail address below.  They will get an initial notification of this job's creation, but will not get any further e-mails."); ?>
<p>
<?php __("If you are the initial reporter of the problem, leave the next two boxes blank."); ?>
<br><br><strong><?php __("Name:"); ?></strong><br>
<?php
PRINT "<input type=text size=15 name=uname value=\"$fname\">";
?>
<br><br>
<strong><?php __("E-Mail:"); ?></strong><br>
<?php PRINT "<input type=text name=uemail size=19 value=\"$uemail\">"; ?>
<br>
<br>
<strong><?php __("Other E-mails:"); ?></strong><br>
<?php PRINT "<input type=\"text\" name=\"other_emails\" size=\"80\" value=\"$other_emails\">"; ?>
<br>
<small><i><?php __("These are e-mail addresses which will get copies of all e-mails sent regarding this work request.  Separate multiple e-mail addresses with spaces or commas."); ?></i></small>
<br>
<br>
<?php
if(Config::Get('userupdates'))
{
  PRINT "<input type=checkbox name=emailupdates value=\"yes\" checked>";
  __("I would like to receive email updates as changes such as followups are added to this tracking.");
  PRINT "<br>";
}
?>



<br><br>
<?php __("Now you recieve the chance to explain the problem.  Please be as clear as possible, but also keep it short.  Do not simply type 'It doesn't turn on', but instead be more specific, for example, 'When I turn my computer on it makes a really loud grinding noise and nothing else happens.'"); ?>
<br>
<br><strong><?php __("Describe the problem:"); ?></strong>
<br>
<?php
$contents = stripslashes(@$contents);
PRINT "<textarea cols=50 rows=14 wrap=soft name=contents>$contents</textarea>"; 
?>
<br>
<input type=submit value="Preview Job"> <input type=reset value="Reset"></form>
<?php
commonFooter();
