<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("normal");
commonHeader(_("Computers") . " - " . _("Search Results"));

if (!preg_match('/^[0-9A-Za-z_]+$/', $field))
{
	trigger_error(sprintf(_("Invalid field name: %s"), $field), E_USER_ERROR);
	die(__FILE__.":".__LINE__.": dying with fatal error\n");
	exit;
}

if (!preg_match('/^[0-9A-Za-z_]+$/', $sort))
{
	trigger_error(sprintf(_("Invalid field name: %s"), $sort), E_USER_ERROR);
	die(__FILE__.":".__LINE__.": dying with fatal error\n");
	exit;
}

$DB = Config::Database();

# If phrase is only a contains search, add the % characters for the mysql query.
if ($phrasetype == "contains")
{
	$newcontains = $DB->getTextValue("%$contains%");
}
else
{
	$newcontains = $DB->getTextValue($contains);
}

$query = "SELECT * FROM computers WHERE ($field LIKE $newcontains) ORDER BY $sort";

PRINT "Showing results where $field contains $contains in $style view 
		sorted by $sort.<br><br>";
PRINT "<table border=0 width=100%>";
PRINT "<tr>";
#PRINT '<td align=center><h4><form method=post 
#		action="'.Config::AbsLoc('users/computers-software-batch.php).'">';
#PRINT "<input type=hidden 
#		name=aquery value=\"$query\"><input type=submit 
#		value=\"Batch Add Software with this Query\"></form>";
#PRINT "</h4></td>";
if(Config::Get('groups'))
{
PRINT "<td align=center><h4>";
PRINT '<form method=get action="'.Config::AbsLoc('users/computers-groups-batch.php').'">';
PRINT "<input type=hidden name=aquery value=\"$query\"><input type=submit 
		value=\""._("Setup groups with this query")."\"></form>";
PRINT "</h4></td>";
}
PRINT "</tr>";
PRINT "</table>";
PRINT "<hr noshade>";

if ($style == "full")
{
	$data = $DB->getAll($query);
	$data = array_slice($data, $goto, 5);
	foreach ($data as $result)
  	{
    		$ID = $result["ID"];
    		showComputer($ID, 0);
  	}

	$backgoto = $goto - 5;
	$forgoto = $goto + 5;
	PRINT "<table border=0><tr><td>";
	if ($backgoto > -1)
	{
		PRINT "<form><input type=hidden name=sort value=\"sort\">
			<input type=hidden name=field value=\"$field\">
			<input type=hidden name=phrasetype value=\"$phrasetype\">
			<input type=hidden name=contains value=\"$contains\">
			<input type=hidden name=style value=\"$style\">
			<input type=hidden name=goto value=$backgoto>
			<input type=submit value=\""._("Previous 5")."\"></form>";
	}
	PRINT "</td><td>";
	PRINT "<form><input type=hidden name=sort value=\"$sort\">
		<input type=hidden name=field value=\"$field\">
		<input type=hidden name=phrasetype value=\"$phrasetype\">
		<input type=hidden name=contains value=\"$contains\">
		<input type=hidden name=style value=\"$style\">
		<input type=hidden name=goto value=$forgoto>
		<input type=submit value=\""._("Next 5")."\"></form>";
	PRINT "</td></tr></table>";
} elseif ($style == "list")
{
  computerListView($query, $sort, $phrasetype);
}
commonFooter();
