//
//      VRM_IN.HPP - Internal version of vrm.hpp
//

#ifndef IRE_NATIVE_EXECUTION_MODULE_HEADER_FILE
#define IRE_NATIVE_EXECUTION_MODULE_HEADER_FILE

#include "core.hpp"

typedef char *STRING;


#ifndef NULL
  #define NULL 0L
#endif


/////// Virtual Runnable Module subroutines ////////

#define AND &&
#define OR ||
#define NOT !

extern void print(char *msg, ...);
extern void printF(char *msg, ...);
extern void vrmclear();
extern void printxy(int x,int y,char *msg, ...);
extern void TextColor(int r,int g, int b);

extern OBJECT *create_object(STRING name, int x, int y);
extern void delete_pending(void);
extern void remove_object(OBJECT *obj);
extern void change_object(OBJECT *obj, STRING name);
extern void replace_object(OBJECT *obj, STRING name);
extern void set_object_direction(OBJECT *obj, int dir);
extern void set_object_sequence(OBJECT *obj, STRING name);
extern void set_object_behaviour(OBJECT *obj, STRING name);
extern void add_goal(OBJECT *o, int priority, char *vrm, OBJECT *target);
extern void end_goal(OBJECT *o);
extern void wipe_goals(OBJECT *o);
extern void kill_goals(OBJECT *o,int p);
#define set_object_behavior set_object_behaviour
extern void spill_contents(OBJECT *bag);
extern void spill_contents_at(OBJECT *bag,int x,int y);
extern int get_flag(OBJECT *target, int flag);
extern int get_tileflag(TILE *target, int flag);
extern void set_flag(OBJECT *target, int flag, int value);
extern void default_flag(OBJECT *target, int flag);
extern void add_quantity(OBJECT *container, char *objecttype, int quantity);
extern int take_quantity(OBJECT *container, char *objecttype, int quantity);
extern int move_quantity(OBJECT *src, OBJECT *dest, char *objecttype, int quantity);
extern int count_objects(OBJECT *container, char *objecttype);
extern OBJECT *find_object_with_tag(int a, char *name);
extern OBJECT *find_container(OBJECT *ex);
extern int get_pflag(OBJECT *target, int flag);
extern void set_pflag(OBJECT *target, int flag, int state);
extern int get_user_flag(char *flag);
extern void set_user_flag(char *flag, int state);
extern int get_local(OBJECT *pl,OBJECT *ch,char *flag);
extern void set_local(OBJECT *pl,OBJECT *ch,char *flag, int state);
extern void show_object(OBJECT *z,int x,int y);
extern void call_vrm(char *name);
extern void call_vrm_number(int name);
extern char *get_vrm_name(int num);
extern void play_song(char *song);
extern void play_sound(char *sound);
extern void object_sound(char *sound, OBJECT *o);
extern void start_song();
extern void stop_song();
extern int object_is_called(OBJECT *obj,char *str);
extern int rnd(int max);
extern void waitfor(unsigned millisec);
extern void waitredraw(unsigned ms);
extern int get_number(int no);

extern TILE *get_tile(int x,int y);
extern OBJECT *get_object(int x,int y);
extern OBJECT *get_solid_object(int x,int y);
extern OBJECT *get_first_object(int x,int y);
extern OBJECT *get_object_below(OBJECT *o);
extern OBJECT *search_container(OBJECT *pocket, char *name);
extern int count_active_objects();
extern void find_objects_with_tag(int a, char *name, int *num, OBJECT **list);

extern void move_to_pocket(OBJECT *src,OBJECT *dest);
extern void transfer_to_pocket(OBJECT *src,OBJECT *dest);
extern int force_from_pocket(OBJECT *obj,OBJECT *container,int x,int y);
extern int move_from_pocket(OBJECT *obj,OBJECT *container,int x,int y);
extern void move_to_top(OBJECT *obj);
extern void move_to_floor(OBJECT *obj);
extern int weigh_object(OBJECT *obj);
extern int get_bulk(OBJECT *obj);
extern int is_tile_solid(int x,int y);
extern int is_tile_water(int x,int y);
extern int is_solid(int x,int y);
extern int in_pocket(OBJECT *o);
extern int move_object(OBJECT *src,int x,int y);
extern void transfer_object(OBJECT *src,int x,int y);
extern int line_of_sight(int xa, int ya, int xb, int yb);
extern int move_forward(OBJECT *a);
extern int move_backward(OBJECT *a);
extern int turn_l(OBJECT *a);
extern int turn_r(OBJECT *a);
extern void wait_for_animation(OBJECT *a);
extern int move_towards(OBJECT *object, OBJECT *end);
extern int move_towards_4(OBJECT *object, OBJECT *end);
extern int move_towards_8(OBJECT *object, OBJECT *end);
extern int move_thick(OBJECT *object, OBJECT *end);

//extern  int add_to_party(OBJECT *new_member);
extern void remove_from_party(OBJECT *member);
extern int choose_member(OBJECT *member, char *player);
extern int choose_leader(OBJECT *leader, char *player, char *others);
extern void move_party_from_object(OBJECT *o, int x, int y);
extern void move_party_to_object(OBJECT *o);

extern void set_darkness(int level);
extern void redraw();
extern void restart();
extern void get_input();
extern int talk_to(char *speechfile,char *startpage);
extern void check_hurt(OBJECT *list);
extern void redraw_map();
extern int get_yn(char *question);
extern void ___lightning(int ticks);
extern void scroll_tile(char *name, int x, int y);
extern void scroll_tile_number(int no, int x, int y);
extern void vrmfade_in();
extern void vrmfade_out();
extern void check_time();
extern OBJECT *find_nearest(OBJECT *o, char *type);
extern OBJECT *find_pathmarker(OBJECT *o, char *name);
extern OBJECT *find_neartag(OBJECT *o, char *type, int tag);

extern char *best_name(OBJECT *o);
extern int character_onscreen(char *pname);
extern int object_onscreen(OBJECT *a);
extern void resume_schedule(OBJECT *o);
extern void resync_everything();
extern void check_object(OBJECT *o, char *label);
extern void set_light(int x, int y, int x2, int y2, int light);
extern void draw_fatline(BITMAP *dest, int x, int y, int radius);
extern void CalcOrbit(int *angle, int radius, int drift, int speed, int *x, int *y, int ox, int oy);
extern void InitOrbit();
//extern void ProjectCorona(int x,int y,int w,int h, int intensity, int falloff);
extern void ProjectCorona(int x,int y,int radius, int intensity, int falloff, int tint);

#define hurt_object(x,y) {x->stats->hp-=y; check_hurt(x);}

#define UP 0
#define DOWN 1
#define LEFT 2
#define RIGHT 3

#define CHAR_U 0
#define CHAR_D 1
#define CHAR_L 2
#define CHAR_R 3

#define IS_ON           0x00000001
#define CAN_OPEN        0x00000002
#define IS_WINDOW       0x00000004
#define IS_SOLID        0x00000008
#define IS_FRAGILE      0x00000010
#define IS_TRIGGER      0x00000020
#define IS_INVISIBLE    0x00000040
#define IS_WIELDED      0x00000040
#define IS_PARTY        0x00000080
#define IS_FIXED        0x00000100
#define IS_CONTAINER    0x00000200
#define IS_TRANSLUCENT  0x00000400
#define IS_LARGE        0x00000800
#define IS_SPIKEPROOF   0x00001000
#define CAN_WIELD       0x00002000
#define DID_STEPUPDATE  0x00004000
#define IS_RANGED       0x00008000
#define DOES_BLOCKLIGHT 0x00010000
#define IS_TABLETOP     0x00020000
#define DID_INIT        0x00040000
#define DID_UPDATE      0x00080000
#define IS_PERSON       0x00100000
#define IS_HORRIBLE     0x00200000
#define IS_HORROR       0x00200000
#define IS_SHOCKING     0x00200000
#define IS_QUANTITY     0x00400000
#define IS_BOAT         0x00800000
#define IS_WATER        0x00800000
#define IS_SHADOW       0x01000000
#define IS_DECOR        0x02000000
#define IS_SYSTEM       0x04000000

#define IS_FEMALE       0x80000001
#define KNOW_NAME       0x80000002
#define IS_HERO         0x80000004
#define CANT_EAT        0x80000008
#define CANT_DRINK      0x80000008      // Synonymous with CANT_EAT
#define IS_CRITICAL     0x80000010
#define NOT_CLOSE_DOOR  0x80000020
#define NOT_CLOSE_DOORS 0x80000020
#define IS_SYMLINK      0x80000040
#define IS_BIOLOGICAL   0x80000080
#define IS_GUARD        0x80000100
#define IS_SPAWNED      0x80000200
#define NOT_OPEN_DOOR   0x80000400
#define NOT_OPEN_DOORS  0x80000400
#define IN_BED          0x80000800


#ifndef ALLEGRO_H
#define KEY_A                 1
#define KEY_B                 2
#define KEY_C                 3
#define KEY_D                 4
#define KEY_E                 5
#define KEY_F                 6
#define KEY_G                 7
#define KEY_H                 8
#define KEY_I                 9
#define KEY_J                 10
#define KEY_K                 11
#define KEY_L                 12
#define KEY_M                 13
#define KEY_N                 14
#define KEY_O                 15
#define KEY_P                 16
#define KEY_Q                 17
#define KEY_R                 18
#define KEY_S                 19
#define KEY_T                 20
#define KEY_U                 21
#define KEY_V                 22
#define KEY_W                 23
#define KEY_X                 24
#define KEY_Y                 25
#define KEY_Z                 26
#define KEY_0                 27
#define KEY_1                 28
#define KEY_2                 29
#define KEY_3                 30
#define KEY_4                 31
#define KEY_5                 32
#define KEY_6                 33
#define KEY_7                 34
#define KEY_8                 35
#define KEY_9                 36
#define KEY_0_PAD             37
#define KEY_1_PAD             38
#define KEY_2_PAD             39
#define KEY_3_PAD             40
#define KEY_4_PAD             41
#define KEY_5_PAD             42
#define KEY_6_PAD             43
#define KEY_7_PAD             44
#define KEY_8_PAD             45
#define KEY_9_PAD             46
#define KEY_F1                47
#define KEY_F2                48
#define KEY_F3                49
#define KEY_F4                50
#define KEY_F5                51
#define KEY_F6                52
#define KEY_F7                53
#define KEY_F8                54
#define KEY_F9                55
#define KEY_F10               56
#define KEY_F11               57
#define KEY_F12               58
#define KEY_ESC               59
#define KEY_TILDE             60
#define KEY_MINUS             61
#define KEY_EQUALS            62
#define KEY_BACKSPACE         63
#define KEY_TAB               64
#define KEY_OPENBRACE         65
#define KEY_CLOSEBRACE        66
#define KEY_ENTER             67
#define KEY_COLON             68
#define KEY_QUOTE             69
#define KEY_BACKSLASH         70
#define KEY_BACKSLASH2        71
#define KEY_COMMA             72
#define KEY_STOP              73
#define KEY_DOT               73
#define KEY_SLASH             74
#define KEY_SPACE             75
#define KEY_INSERT            76
#define KEY_DEL               77
#define KEY_HOME              78
#define KEY_END               79
#define KEY_PGUP              80
#define KEY_PGDN              81
#define KEY_LEFT              82
#define KEY_RIGHT             83
#define KEY_UP                84
#define KEY_DOWN              85
#define KEY_SLASH_PAD         86
#define KEY_ASTERISK          87
#define KEY_MINUS_PAD         88
#define KEY_PLUS_PAD          89
#define KEY_DEL_PAD           90
#define KEY_ENTER_PAD         91
#define KEY_PRTSCR            92
#define KEY_PAUSE             93
#define KEY_YEN               94
#define KEY_YEN2              95

#define KEY_MODIFIERS         96

#define KEY_LSHIFT            96
#define KEY_RSHIFT            97
#define KEY_LCONTROL          98
#define KEY_RCONTROL          99
#define KEY_ALT               100
#define KEY_ALTGR             101
#define KEY_LWIN              102
#define KEY_RWIN              103
#define KEY_MENU              104
#define KEY_SCRLOCK           105
#define KEY_NUMLOCK           106
#define KEY_CAPSLOCK          107
#endif

#define MAX_MEMBERS 128

// Tint bitmasks
#define TINT_RED 1
#define TINT_GREEN 2
#define TINT_BLUE 4
#define TINT_YELLOW 3
#define TINT_PURPLE 5
#define TINT_MAGENTA 5
#define TINT_CYAN 6
#define TINT_LIGHTBLUE 6
#define TINT_WHITE 7

#endif

