/*
 *
 * old "plain file" backend to fetchipac
 * Copyright (C) 2001 Al Zaharov
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author can be reached via email: moritz@daneben.de, or by
 * snail mail: Moritz Both, Im Moore 26, 30167 Hannover,
 *             Germany. Phone: +49-511-1610129
 *
 */

#include "ipac.h"
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/param.h>
#include <unistd.h>

char *rulesfile = NULL;

/* plain file ipac interface entries */
int files_ipac_open(int flag);
int files_ipac_get_user_list(user_list **list);
int files_ipac_get_raw_list(char *ag_name, char *login, 
		raw_rule_type **data);
int files_ipac_delete_record(timestamp_t timestamp);
double files_ipac_get_cash(char *login);
int files_ipac_set_cash(char *login, double cash);
double files_ipac_get_price(char *rule_name);
double files_ipac_get_kredit(char *login);
int files_ipac_get_pay_type(char *rule_name);
char * files_ipac_get_last_paid(char *service_name);
int files_ipac_set_last_paid(char *login, char *paid);
int files_ipac_login(char *login);
int files_ipac_logout(char *login, double cash);
int files_ipac_close();

/* ------------------------------------------------------------------------ *
 static utils. (z2v)
 * ------------------------------------------------------------------------ */
static void ltrim(char *s);
static void rtrim(char *s);
static int  ipac_trim_spc( char *src );

static const access_agent_t interface_entry = {
	"files",
	files_ipac_open,
	files_ipac_get_user_list,
	files_ipac_get_raw_list,
	files_ipac_get_cash,
	files_ipac_set_cash,
	files_ipac_get_price,
	files_ipac_get_kredit,
	files_ipac_get_pay_type,
	files_ipac_get_last_paid,
	files_ipac_set_last_paid,
	files_ipac_login,
	files_ipac_logout,
	files_ipac_close
};

const access_agent_t *ipac_ac_interface_files() {
	return &interface_entry;
};



int files_ipac_open(int flag)
{
	/* nothing to do. */
	return 0;
}

// always fails
int files_ipac_login(char *login)
{
	return 1;
}

// always fails too
int files_ipac_logout(char *login, double cash)
{
	return 1;
}

double
files_ipac_get_kredit(char *login)
{
	return 0;
}

int files_ipac_set_last_paid(char *login, char *paid)
{
	return 1;
}

int
files_ipac_get_user_list(user_list **list)
{
	*list = new_user();
	strcpy((*list)->login, "admin");
	return 0;
}

/*
 * Analogue to perl's chomp
 */
static char
*chomp(char *s)
{
	char *tmp=NULL;
	if (s)
		if ((tmp=strchr(s, '\n'))!=NULL)
			s[tmp-s]='\0';
	return s;
}

/*
 * new functions are still not fully supported in plain-file method
 * this function is here for compatibility only - it does not support
 * storage agents and login names. Eats old styled config file
 */
int files_ipac_get_raw_list(char *ag_name, char *login, raw_rule_type **data)
{
	FILE *conf;
	FILE *nets;
	char buf[MAX_RULE_NAME_LENGTH + 100];
	char file_name[MAX_RULE_NAME_LENGTH + 100];
	char chain[MAX_RULE_NAME_LENGTH + 1];
	char net_buf[MAX_RULE_NAME_LENGTH + 100];
	char *tmp, *src, *dst, *buf1, *tmp1, *tmp2;
	raw_rule_type *r1, *r, *r2, *r3;
	int i, n, conf_line, file_line;
	
	if (verbose)
		fprintf(stderr, "Reading and parsing rules file \"%s\"\n", 
								    rulesfile);

	if (!rulesfile) {
		fprintf(stderr, "%s: rulesfile is not specified in your config file\n", me);
		exit (1);
	}

	conf = fopen(rulesfile, "r");
	if (!conf) {
		fprintf(stderr, "%s: opening rules file \"%s\": %s\n",
			me, rulesfile, strerror(errno));
		exit (1);
	}
	r1 = NULL; conf_line = 0; file_line=0;
	while(fgets(buf, MAX_RULE_NAME_LENGTH + 100, conf)) {
		file_line++;
		if ((*buf=='#')||(*buf=='\n')||(*buf=='\t')||(*buf==' '))
			continue;
		conf_line++;
		r = new_raw_rule();
		if (r1 == NULL)
			*data = r;
		else
			r1->next = r;
         
		r1 = r2 = r3 = r;
		buf1=xstrdup(buf);
		if (verbose>1)
			printf("Parsing line %d \"%s\"\n", file_line, buf1);
				
		tmp = strsep(&buf1, "|");	// get rule name
		strncpy(r->name, tmp, MAX_RULE_NAME_LENGTH);
		r->name[MAX_RULE_NAME_LENGTH]='\0';

		if (verbose > 0)
			printf("CONFIG: Acc.rule: '%s' -> ", r->name );
                                               
		// trim left and right spaces.
		ltrim(r->name);   
		rtrim(r->name);      
		ipac_trim_spc(r->name);
		if (verbose > 0)
			printf("[%s]\n", r->name ); 
               
              
		tmp = strsep(&buf1, "|");	// get destination
		strncpy(r->dest, tmp, MAX_RULE_NAME_LENGTH);
		r->dest[MAX_RULE_NAME_LENGTH]='\0';
		tmp = strsep(&buf1, "|");	// get iface
		strncpy(r->iface, tmp, 9);
		tmp = strsep(&buf1, "|");	// get protocol
		strncpy(r->protocol, tmp, 5);
		src = strsep(&buf1, "|");	// get source address/ports
		dst = strsep(&buf1, "|");	// destination
		if (!(src && dst)) {
			fprintf(stderr, "Incorrect config line %d\n%s\n", 
							file_line, buf);
			return 1;
		}

		if (strchr(src, '@') && strchr(dst,'@')) {
			fprintf(stderr, "Files in both source and destination "
				"is not allowed, config line %d\n", file_line);
			return 1;
		}

		if ((tmp=strchr(src, '@')) != NULL) { //tmp+1 points to file name
			if ((tmp1=strchr(tmp+1, '@')) == NULL) { //tmp1+1 = chain name
				fprintf(stderr, "Malformed config line %d", conf_line);
				return 1;
			}
			strncpy(file_name, tmp+1, (int) (tmp1-tmp)-1);
			file_name[tmp1-tmp-1] = '\0';
			if ((tmp2=strchr(tmp1+1, ' ')) != NULL) {
				strncpy(chain, tmp1+1, (int) (tmp2-tmp1)-1);
				chain[tmp2-tmp1-1]='\0';
				fprintf(stderr, "Error: ports are not allowed "
					"with network file, line %d\n", conf_line);
				exit (1);
			} else
				strncpy(chain, tmp1+1, (int) 
					(MAX_RULE_NAME_LENGTH-(tmp1-tmp)-1));
			if (verbose>2) {
				printf("File with net ip's is \"%s\"\n", file_name);
				printf("Chain name for that net is \"%s\"\n", chain);
			}

			r = new_raw_rule();
			r1->next = r;
			strcpy(r->dest, chain);
			strcpy(r->iface, r1->iface);
			strcpy(r->protocol, r1->protocol);
		// FIXME: dangerous! string overlap
			strcpy(r1->snet, "0/0");
			if (((strchr(dst, ' '))!=NULL) || (dst[0]=='\n')
						    || (dst[0]=='\0'))
				strcpy(r1->dnet, "0/0");
			else
				strcpy(r1->dnet, dst);
			chomp(r1->dnet);
			strcpy(r->name, r1->name);
			strcpy(r1->name, "%chain% ");
			strncpy(r1->name+8, chain, MAX_RULE_NAME_LENGTH-9);
//			r1 = r2 = r3 = r;
			r2 = r3 = r;

			strcpy(chain, CONFDIR);
			strcat(chain, "/");
//			if ((chain+strlen(chain))[0]!='/')
//				(chain+strlen(chain))[0]='/';
			strcpy(chain+strlen(chain), file_name);
			nets = fopen(chain, "r");
			if (!nets) {
				fprintf(stderr, "%s: opening config \"%s%s\": %s\n",
					me, CONFDIR, file_name, strerror(errno));
				return 1;
			}
			while (fgets(net_buf, MAX_RULE_NAME_LENGTH, nets)) {
            			if ((*net_buf=='#')||(*net_buf=='\n')
					    ||(*net_buf=='\t')||(*net_buf==' '))
		                        continue;                                        			
				chomp(net_buf);
				if (r1!=r) {
					strncpy(r->snet, net_buf, sizeof(r->snet)-1);
					strncpy(r->dnet, r1->dnet, sizeof(r->dnet)-1);
				} else {
					r = new_raw_rule();
					r1->next = r;
					strncpy(r->name, r1->name, MAX_RULE_NAME_LENGTH);
					strncpy(r->dest, r1->dest, MAX_RULE_NAME_LENGTH);
					strncpy(r->iface, r1->iface, 9);
					strncpy(r->protocol, r1->protocol, 5);
					strncpy(r->snet, net_buf, sizeof(r->snet)-1);
					strncpy(r->dnet, r1->dnet, sizeof(r->dnet)-1);
				}
				r1 = r;
			}
			fclose (nets);
			strcpy(src, "");
		} else 

		if ((tmp=strchr(dst, '@')) != NULL) { //tmp+1 points to file name
			if ((tmp1=strchr(tmp+1, '@')) == NULL) { //tmp1+1 = chain name
				fprintf(stderr, "Malformed config line %d", conf_line);
				return 1;
			}
			strncpy(file_name, tmp+1, (int) (tmp1-tmp)-1);
			file_name[tmp1-tmp-1] = '\0';
			if ((tmp2=strchr(tmp1+1, ' ')) != NULL) {
				strncpy(chain, tmp1+1, (int) (tmp2-tmp1)-1);
				fprintf(stderr, "Error: ports are not allowed "
					"with network file, line %d\n", conf_line);
				exit (1);
			} else
				strncpy(chain, tmp1+1, (int) 
					(MAX_RULE_NAME_LENGTH-(tmp1-tmp)-1));
			chomp(chain);
			if (verbose>2) {
				printf("File with net ip's is \"%s\"\n", file_name);
				printf("Chain name for that net is \"%s\"\n", chain);
			}

			r = new_raw_rule();
			r1->next = r;
			strcpy(r->dest, chain);
			strcpy(r->iface, r1->iface);
			strcpy(r->protocol, r1->protocol);
			strcpy(r1->dnet, "0/0");
		// FIXME: dangerous! string overlap
			if (((strchr(src, ' '))!=NULL) || (src[0]=='\n')
						    || (src[0]=='\0'))
				strcpy(r1->snet, "0/0");
			else
				strncpy(r1->snet, src, sizeof(r->snet)-1);
			chomp(r1->snet);
			chomp(r1->name);
			strcpy(r->name, r1->name);
			strcpy(r1->name, "%chain% ");
			strncpy(r1->name+8, chain, MAX_RULE_NAME_LENGTH-9);
			r2 = r3 = r;

			strcpy(chain, CONFDIR);
			if ((chain+strlen(chain))[0]!='/')
				(chain+strlen(chain))[0]='/';
			strcpy(chain+strlen(chain), file_name);
			nets = fopen(chain, "r");
			if (!nets) {
				fprintf(stderr, "%s: opening config \"%s%s\": %s\n",
					me, CONFDIR, file_name, strerror(errno));
				return 1;
			}
			while (fgets(net_buf, MAX_RULE_NAME_LENGTH, nets)) {
                                if ((*net_buf=='#')||(*net_buf=='\n')           
                                            ||(*net_buf=='\t')||(*net_buf==' '))
                            		continue;                               			
				chomp(net_buf);
				if (r1!=r) {
					strncpy(r->dnet, net_buf, sizeof(r->dnet)-1);
					strncpy(r->snet, r1->snet, sizeof(r->snet)-1);
				} else {
					r = new_raw_rule();
					r1->next = r;
					strncpy(r->name, r1->name, MAX_RULE_NAME_LENGTH);
					strncpy(r->dest, r1->dest, MAX_RULE_NAME_LENGTH);
					strncpy(r->iface, r1->iface, 9);
					strncpy(r->protocol, r1->protocol, 5);
					strncpy(r->dnet, net_buf, sizeof(r->dnet)-1);
					strncpy(r->snet, r1->snet, sizeof(r->snet)-1);
				}
				r1 = r;
			}
			fclose (nets);
			strcpy(dst, "");
		} else {

		if (strlen(src)) {
			tmp = strtok(src, " ");		// split source to address/proto
			strncpy(r->snet, tmp, sizeof(r->snet)-1);

			tmp = strtok(NULL, " ");	// are there any ports?
			if (tmp)
				strncpy(r->sport, tmp, 19);
			tmp = strtok(NULL, " ");
			while (tmp) { // uh! there are another ports
				r = new_raw_rule();
				r1->next = r;
				strncpy(r->name, r1->name, MAX_RULE_NAME_LENGTH);
				strncpy(r->dest, r1->dest, MAX_RULE_NAME_LENGTH);
				strncpy(r->iface, r1->iface, 9);
				strncpy(r->protocol, r1->protocol, 5);
				strncpy(r->snet, r1->snet, sizeof(r->snet)-1);
				strncpy(r->sport, tmp, 19);
				r1 = r;
				tmp = strtok(NULL, " ");
			}
		} else {
			strcpy(r->snet, "0/0");
			strcpy(r->sport, "");
		}
		r=r2;
		if (strlen(dst)>1) {
			tmp = strtok(dst, " \n");
			tmp1 = strtok(NULL, " \n");
			n=0;
			while (r) {
				strncpy(r->dnet, tmp, sizeof(r->dnet)-1);
				if (tmp1)
					strncpy(r->dport, tmp1, 19);
				else 
					r->dport[0]='\0';
				r=r->next;
				n++;
			}
			tmp = strtok(NULL, " \n");
			while (tmp) { // uh-uh!!! whheee.. ugly?
				r2 = r3;
				for (i=0;i<n;i++) {
					r = new_raw_rule();
					r1->next = r;
					strncpy(r->name, r2->name, MAX_RULE_NAME_LENGTH);
					strncpy(r->dest, r2->dest, MAX_RULE_NAME_LENGTH);
					strncpy(r->iface, r2->iface, 9);
					strncpy(r->protocol, r2->protocol, 5);
					strncpy(r->snet, r2->snet, sizeof(r->snet)-1);
					strncpy(r->sport, r2->sport, 19);
					strncpy(r->dnet, r2->dnet, sizeof(r->dnet)-1);
					strncpy(r->dport, tmp, 19);
					r1 = r;
					r2 = r2->next;
				}
				tmp = strtok(NULL, " \n");
			}
			
		} else {		// destination network is not specified
			while (r) {
				strcpy(r->dnet, "0/0");
				strcpy(r->dport, "");
				r=r->next;
			}
		}
		}
	}
	fclose(conf);	
	if (conf_line!=0)
		return 0;
	else {
		fprintf(stderr, "Config file is empty..\n");
		return 1;
	}
}

// This always return positive balance so that old-styled ipac supported
double
files_ipac_get_cash(char *login)
{
	return 1;
}

int files_ipac_set_cash(char *login, double cash)
{
	return 0;
};

double files_ipac_get_price(char *rule_name)
{
	return 0;
};

int files_ipac_get_pay_type(char *rule_name)
{
	return 0;
};

char * files_ipac_get_last_paid(char *service_name)
{
	return NULL;
};

int files_ipac_close(void)
{
	/* nothing to do. */
	return 0;
}

// ------------------------------------
// ltrim
static void ltrim(char *s) {
	char *t;
	register int i;
	t = strdup( s );   
  
	// check if strdup fails.
	if (!t) return;
  
	i=0;
  
	while( t[i] ) {
    		if (t[i]!=' ') 
			break;
		i++; 
	}
	strncpy( s, &t[i], MAX_RULE_NAME_LENGTH );
	free(t);
}

// ------------------------------------
// rtrim
static void rtrim(char *s) {
	register int i = strlen(s);
    
	while( --i >= 0 ) {
    		if (s[i]!=' ') 
			break;
		s[i] = '\0';
	}
}

// ------------------------------------
// ipac_trim_spc
// deleted additional (and not needed) spaces.
// Return count of deleted spaces.
static int ipac_trim_spc(char *src) {
	int slen = strlen(src);
	short fg_spc;
        char *p;
        char *s = src;

	char *des = calloc(slen + 1, 1);
		if (!des) return 0;
   
	p = des;
   
        fg_spc = 1;
    
        while( *s ) {
	        if (*s==' ') { 
        		if (fg_spc) 
				{*p++ = *s; fg_spc = 0;}
        		s++;
    		} else {
        		*(p++) = *(s++);
        		fg_spc = 1;
    		}   
	}
    
	*p='\0';
	strncpy (src, des, slen);
	free (des);
	return p - des;
}                                                        
