#include <curses.h>
#include <signal.h> 

static void finish(int sig); main(int argc, char *argv[])
{
    /* initialize your non-curses data structures here */     
  (void) signal(SIGINT, finish);      /* arrange interrupts to terminate */     
  (void) initscr();      /* initialize the curses library */
  keypad(stdscr, TRUE);  /* enable keyboard mapping */
  (void) nonl();         /* tell curses not to do NL->CR/NL on output */
  (void) cbreak();       /* take input chars one at a time, no wait for \n */
  (void) noecho();       /* don't echo input */     
  if (has_colors()) {
    start_color();         /*
			    * Simple color assignment, often all we need.
			    */
    init_pair(COLOR_BLACK, COLOR_BLACK, COLOR_BLACK);
    init_pair(COLOR_GREEN, COLOR_GREEN, COLOR_BLACK);
    init_pair(COLOR_RED, COLOR_RED, COLOR_BLACK);
    init_pair(COLOR_CYAN, COLOR_CYAN, COLOR_BLACK);
    init_pair(COLOR_WHITE, COLOR_WHITE, COLOR_BLACK);
    init_pair(COLOR_MAGENTA, COLOR_MAGENTA, COLOR_BLACK);
    init_pair(COLOR_BLUE, COLOR_BLUE, COLOR_BLACK);
    init_pair(COLOR_YELLOW, COLOR_YELLOW, COLOR_BLACK);
  }     for (;;)
    {
      int c = getch();     /* refresh, accept single keystroke of input */      
      /* process the command keystroke */
    }     finish(0);               /* we're done */
} 

static void finish(int sig)
{
  endwin();     /* do your non-curses wrapup here */     exit(0);
}
