#ifndef SEEN_DRAW_ANCHOR_H
#define SEEN_DRAW_ANCHOR_H

/** \file Drawing anchors. */

#include <glib/gtypes.h>

#include "libnr/nr-point.h"
struct SPDrawContext;
struct SPCurve;
struct SPCanvasItem;


struct SPDrawAnchor { // FIXME: make this a regular knot, this will allow to set statusbar tips
    SPDrawContext *dc;
    SPCurve *curve;
    guint start : 1;
    guint active : 1;
    NR::Point dp;
    NR::Point wp;
    SPCanvasItem *ctrl;
};


SPDrawAnchor *sp_draw_anchor_new(SPDrawContext *dc, SPCurve *curve, gboolean start,
                                 NR::Point delta);
SPDrawAnchor *sp_draw_anchor_destroy(SPDrawAnchor *anchor);
SPDrawAnchor *sp_draw_anchor_test(SPDrawAnchor *anchor, NR::Point w, gboolean activate);


#endif /* !SEEN_DRAW_ANCHOR_H */

/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0)(case-label . +))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=8:softtabstop=4:encoding=utf-8:textwidth=99 :
