/* $Id: im-trigger-notify.c,v 1.1.1.1 2002/08/31 04:18:07 himi Exp $ */


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#if defined(lint) && defined(HAVE_NOTE_H)
#include <note.h>
#endif /* lint && HAVE_NOTE_H */

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


IIIMP_message *
iiimp_trigger_notify_new(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_card16	flag)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_TRIGGER_NOTIFY;
    m->im_id = im_id;
    m->ic_id = ic_id;
    m->v.trigger_notify.flag = flag;
    return m;
}


void
iiimp_trigger_notify_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(data_s))
#endif /* lint && HAVE_NOTE_H */
    free(m);
}


uchar_t *
iiimp_trigger_notify_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_card16	flag,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;

    nbyte = 0;
    nbyte += 2;	/* input method id */
    nbyte += 2;	/* input context id */
    nbyte += 2;	/* flag */
    nbyte += 2;	/* PAD(2) */

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_TRIGGER_NOTIFY, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(ic_id, rest, p, data_s->byte_swap);
    PUTU16(flag, rest, p, data_s->byte_swap);
    PUTU16(0, rest, p, data_s->byte_swap);

    return buf;
}


IIIMP_message *
iiimp_trigger_notify_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *		m;
    IIIMP_trigger_notify_v *	v;
    size_t			rest;
    const uchar_t *		p;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 2 + 2)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.trigger_notify);

    m->opcode = opcode;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    GETU16(m->ic_id, rest, p, data_s->byte_swap);
    GETU16(v->flag, rest, p, data_s->byte_swap);
    SKIP16(rest, p);

    if ((0 != v->flag) && (1 != v->flag)) {
	iiimp_trigger_notify_delete(data_s, m);
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    *nbyte = rest;
    *ptr = p;

    return m;
}


void
iiimp_trigger_notify_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, m->ic_id);
    (void)fprintf(data_s->print_fp, "\tflag = %s\n",
		  ((0 == m->v.trigger_notify.flag) ?
		   "on" : ((1 == m->v.trigger_notify.flag) ?
			   "off" : "unknown")));
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
