/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include <stdlib.h>
#include "GeneType.h"
#include "PyStatic.h"

#define MAXNUM 14000
#define MAXDYZ 2000

void CreateDYZ(FILE *outfp);

typedef struct _Big5_PY {
	int code;
	unsigned char hanzi[3];
	char pinyin[8];
	char tone;
} Big5_PY;

Big5_PY big5[MAXNUM];
Big5_PY dyz[MAXDYZ];

int dyznumber, big5number;

void main() {
	FILE *fp;
	FILE *fp1, *fp2, *fp3;
	int i = 0, code, j = 0, k = 0;
	unsigned int tones, tmp;
	unsigned char buf[1024], yinjie[10], hanzi[3], lasthanzi[3], hanzicode[10], tone[2];

	fp = fopen("../data/BIG5PY.txt", "r");
	fp1 = fopen("../data/BIG5.txt", "w");
	fp2 = fopen("PyBig5.h", "w");

	lasthanzi[0] = 0;
	dyznumber = 0;
	i = j = 0;

	while(!feof(fp)) {
		fgets((char *)buf, 1024, fp);
		if(feof(fp)) break;
		sscanf((char *)buf, "%s	%s	%s", hanzicode, hanzi, yinjie);

		if(strcmp(hanzi, lasthanzi) == 0) {
			dyz[j].code = hanzi[0] * 256 + hanzi[1];
			dyz[j].tone = yinjie[strlen(yinjie) - 1];
			yinjie[strlen(yinjie) - 1] = 0;
			strcpy(dyz[j].hanzi, hanzi);
			strcpy(dyz[j].pinyin, yinjie);
			j ++;
		}
		else {
			big5[i].code = hanzi[0] * 256 + hanzi[1];
			big5[i].tone = yinjie[strlen(yinjie) - 1];
			yinjie[strlen(yinjie) - 1] = 0;
			strcpy(big5[i].hanzi, hanzi);
			strcpy(big5[i].pinyin, yinjie);
			i ++;

			strcpy(lasthanzi, hanzi);
			lasthanzi[2] = 0;
		}
	}

	big5number = i;
	dyznumber = j;

	tones = 0; j = 0; k = 0;
	fprintf(fp2, "/* ");
	fprintf(fp2, "\n * PyBig5.h");
	fprintf(fp2, "\n * This file is automaticlly generated from BIG5PY.txt.");
	fprintf(fp2, "\n * Don't Edit it.");
	fprintf(fp2, "\n */\n");

	fprintf(fp2, "\n#ifndef _PYBIG5_H");
	fprintf(fp2, "\n#define _PYBIG5_H\n");

	fprintf(fp2, "\nstatic unsigned int BIG5TONE[] = {\n\t");
	for(i = 0; i < big5number; i ++) {
		if(big5[i].code == 0xC940) {
			k = j % 8;
			if(tones != 0) 
				for(; k < 8; k ++) tones *= 16;
			fprintf(fp2, "0x%X,\n \t", tones);
			j = 0;
			tones = 0;
		}
		tones = (tones * 16) + big5[i].tone - 48;
		if(j % 8 == 7) {
			fprintf(fp2, "0x%X, ", tones);
			tones = 0;
			if(k % 8 == 7) fprintf(fp2, "\n\t");
			k ++;
		}
		j ++;
	}
	k = j % 8;
	if(tones != 0) 
		for(; k < 8; k ++) tones *= 16;
	fprintf(fp2, "0x%X\n}; \n", tones);

	tones = 0; j = 0; k = 0;
	fprintf(fp2, "\nstatic unsigned int DYZTONE[] = {\n\t");
	for(i = 0; i < dyznumber; i ++) {
		tones = (tones * 16) + dyz[i].tone - 48;
		if(j % 8 == 7) {
			fprintf(fp2, "0x%X, ", tones);
			tones = 0;
			if(k % 8 == 7) fprintf(fp2, "\n\t");
			k ++;
		}
		j ++;
	}
	k = j % 8;
	if(tones != 0)
		for(; k < 8; k ++) tones *= 16;
 	fprintf(fp2, "0x%X\n}; \n", tones);

	for(i = 0; i < big5number; i ++) 
		fprintf(fp1,"0x%x %s %s %d\n", big5[i].code, big5[i].hanzi, big5[i].pinyin, big5[i].tone - 48);
	fclose(fp1);

	ProcBig5Hz(fp2);
	CreateDYZ(fp2);

	fclose(fp);

	fprintf(fp2, "\n/*");
	fprintf(fp2, "\n * High Frequence HANZI");
	fprintf(fp2, "\n */");
	fprintf(fp2, "\nstatic UCHAR HIFREQHANZI[26][14] = {");
	fprintf(fp2, "\n	\"\",   \"t\", \"\", \"\", \"x\",");
	fprintf(fp2, "\n	\"\",   \"w\", \"|\", \"~\", \"\",");
	fprintf(fp2, "\n	\"}\", \"{\", \"v\", \"z\", \"\",");
	fprintf(fp2, "\n	\"u\", \"\", \"\", \"\", \"\",");
	fprintf(fp2, "\n	\"y\", \"\",   \"\", \"\",   \"\",");
	fprintf(fp2, "\n	\"\"");
	fprintf(fp2, "\n};\n");

	fprintf(fp2, "\n#endif   /* End of _PYBIG5_H */\n");
	fclose(fp2);
	exit(0);
}

void CreateDYZ(FILE *outfp) {
	int i, j;
	int hi, low;

	fprintf(outfp, "\n/*");
	fprintf(outfp, "\n** DUOYINZILIST by Hanzi Internal Code and");
	fprintf(outfp, "\n** Their Pronunciation (Yinjie String) in DUOYINZIYINJIECODE.");
	fprintf(outfp, "\n** Some Hanzi Have 3 or 4 Pronunciation, So, Their Codes");
	fprintf(outfp, "\n** Appear Several Times In DYZLIST.");
	fprintf(outfp, "\n*/");
	
	fprintf(outfp, "\n\n#define TOTAL_DYZYINJIE  %d", dyznumber);
	fprintf(outfp, "\nstatic int  DYZLIST[TOTAL_DYZYINJIE] = {\n\t");
	
	for(i = 0; i < dyznumber; i ++) { 
		fprintf(outfp, "0x%X, ", dyz[i].code);
		if(i % 8 == 7) fprintf(outfp, "\n\t");
	}
	fprintf(outfp, "\n};\n");

	fprintf(outfp, "\n/*");
	fprintf(outfp, "\n** DuoYinZi YinJie Code. Corresponding to the Above Struct.");
	fprintf(outfp, "\n*/");

	fprintf(outfp, "\nstatic int  DYZYJCODE[TOTAL_DYZYINJIE] = {\n\t");
	for(i = 0; i < dyznumber; i ++) {
		fprintf(outfp, "%6d, ", FastMatchYinJieStr(dyz[i].pinyin));
		if(i % 8 == 7) fprintf(outfp, "\n\t");
	}
	fprintf(outfp, "\n};\n");

	fprintf(outfp, "\n/*");
	fprintf(outfp, "\n** Index Of Above DuoYinZiList by High Byte of Hzcode.");
	fprintf(outfp, "\n** Distance Of 0xA4(40) to 0xF9(DC) is: 0x56 = 86");
	fprintf(outfp, "\n*/");

	fprintf(outfp, "\n\n#define DISTOF_A4_F9 86");
	fprintf(outfp, "\nstatic int INDEXOFDYZLIST[DISTOF_A4_F9 + 1] = {");
	fprintf(outfp, "\n\t%4d,", 0);
	hi = 0xA500;
	j = 5;
	for(i = 0; i < dyznumber; i ++) {
		if(dyz[i].code >= hi) {
			fprintf(outfp, "%4d,", i);
			if(j % 16 == 15) fprintf(outfp, "\n\t");
			if(hi == 0xC700) {
				fprintf(outfp, "%4d,%4d,", i, i);
				hi += 0x0300;
				j += 2;
			}
			else hi += 0x0100;
			j ++;
		}
	}
	fprintf(outfp, "%4d\n};\n", dyznumber);
}

/*
**  Lookup the equal string of szPystr in YINJIESTR_CSZ[415].
**  If successfully, return 0~414; otherwise, return -1.
**  If chFirst is 'i' 'u' or 'v', return -1 directly.
*/
JINT FastMatchYinJieStr(CHAR* szPystr)
{
        JINT    i, j, nLen;
        CHAR    chFirst;
        JINT    nFromYJStr, nToYJStr, nShengmuIndex;

        i = 0;
        nLen = (JINT)strlen(szPystr);

        j = 0;
        if (nLen > 0)
        {
                chFirst = szPystr[0];

                if ((chFirst == 'i') || (chFirst == 'u') || (chFirst == 'v'))
                        return (-1);

                nFromYJStr = INDEXSMTOYINJIE[ INDEXMAGIC[(JINT)(chFirst - 'a')] ];
                nToYJStr = INDEXSMTOYINJIE[ INDEXMAGIC[(JINT)(chFirst - 'a')] + 1];
                nShengmuIndex = INDEXMAGIC[(JINT)(chFirst - 'a')];

                if ((chFirst == 'c') && (nLen > 1) && (szPystr[1] == 'h'))
                {
                        nFromYJStr = INDEXSMTOYINJIE[3];
                        nToYJStr = INDEXSMTOYINJIE[4];
                        nShengmuIndex = 3;
                }
                else if ((chFirst == 's') && (nLen > 1) && (szPystr[1] == 'h'))
                {
                        nFromYJStr = INDEXSMTOYINJIE[19];
                        nToYJStr = INDEXSMTOYINJIE[20];
                        nShengmuIndex = 19;
                }
                else if ((chFirst == 'z') && (nLen > 1) && (szPystr[1] == 'h'))
                {
                        nFromYJStr = INDEXSMTOYINJIE[25];
                        nToYJStr = INDEXSMTOYINJIE[26];
                        nShengmuIndex = 25;
                }
               i = nFromYJStr;
                do {
                        j = strcmp (YINJIESTR_CSZ[i], szPystr);
                        i++;
                } while ((i < nToYJStr) && (j != 0));
        }

        if (j == 0)
                return (i - 1);
        else
                return (-1);
}


JINT GetNextLine(FILE* pfFile, CHAR* szBuf)
{
        JINT    i = 0;

        do
        {
                fread (&szBuf[i], 1, 1, pfFile);
                i ++;
        } while (!feof(pfFile) && (szBuf[i-1] != 0x0A));
        szBuf[i-1] = '\0';
        if (!feof(pfFile))
                return 1;
        else
                return 0;
}

