/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include <stdlib.h>
#include "Converter.h"

#define False 0
#define True 1
/*
#define DEBUG
*/

typedef unsigned char *MString;
typedef unsigned char *XPointer;

static KeySym getX11KeySym(long awtKey)
{
    int i;
    for (i = 0; keymapTable[i].awtKey != 0; i++) {
        if (keymapTable[i].awtKey == awtKey) {
            return keymapTable[i].x11Key;
        }
    }
    return 0;
}

modifyEvent(long *keyCode, unsigned short *keyChar, long *State)
{
    KeySym keysym = 0;
    long state = 0;

    DEBUG_printf("keycode:0x%x, keychar:0x%x, keystate:0x%x\n", *keyCode, *keyChar, *State);
    switch(*keyCode) {
      case java_awt_event_KeyEvent_VK_ENTER:
      case java_awt_event_KeyEvent_VK_BACK_SPACE:
      case java_awt_event_KeyEvent_VK_TAB:
      case java_awt_event_KeyEvent_VK_ESCAPE:
      case java_awt_event_KeyEvent_VK_DELETE:
          keysym = getX11KeySym(*keyCode);
          break;
      default:
          if (*keyChar != 0 && *keyChar < 256) {
              keysym = *keyChar;
          } else {
              keysym = getX11KeySym(*keyCode);
          }
          break;
    }
    if (keysym >= 'A' && keysym <= 'Z') {
        state |= ShiftMask;
    }
    if (*State & java_awt_event_InputEvent_SHIFT_MASK) {
        state |= ShiftMask;
    }
    if (*State & java_awt_event_InputEvent_CTRL_MASK) {
        state |= ControlMask;
    }
    if (*State & java_awt_event_InputEvent_META_MASK) {
        state |= awt_MetaMask;
    }
    if (*State & java_awt_event_InputEvent_ALT_MASK) {
        state |= awt_AltMask;
    }

    *keyCode = keysym;
    if((*keyChar < 0x20) || (*keyChar > 0x7E))
	*keyChar = 0xFF;
    if(state != 0) *State = state;

    DEBUG_printf("keycode:0x%x, keychar:0x%x, keystate:0x%x\n", *keyCode, *keyChar, *State);
}

